/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.SessionManagerParametersCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSessionRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, StartSessionRequest> {
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartSessionRequest.getter(StartSessionRequest::target)).setter(StartSessionRequest.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartSessionRequest.getter(StartSessionRequest::documentName)).setter(StartSessionRequest.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(StartSessionRequest.getter(StartSessionRequest::parameters)).setter(StartSessionRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, DOCUMENT_NAME_FIELD, PARAMETERS_FIELD));
    private final String target;
    private final String documentName;
    private final Map<String, List<String>> parameters;

    private StartSessionRequest(BuilderImpl builder) {
        super(builder);
        this.target = builder.target;
        this.documentName = builder.documentName;
        this.parameters = builder.parameters;
    }

    public String target() {
        return this.target;
    }

    public String documentName() {
        return this.documentName;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSessionRequest)) {
            return false;
        }
        StartSessionRequest other = (StartSessionRequest)((Object)obj);
        return Objects.equals(this.target(), other.target()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        return ToString.builder((String)"StartSessionRequest").add("Target", (Object)this.target()).add("DocumentName", (Object)this.documentName()).add("Parameters", this.parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSessionRequest, T> g) {
        return obj -> g.apply((StartSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String target;
        private String documentName;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartSessionRequest model) {
            super(model);
            this.target(model.target);
            this.documentName(model.documentName);
            this.parameters(model.parameters);
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = SessionManagerParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = SessionManagerParametersCopier.copy(parameters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSessionRequest build() {
            return new StartSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSessionRequest> {
        public Builder target(String var1);

        public Builder documentName(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

