/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.PatchGroupPatchBaselineMapping;
import software.amazon.awssdk.services.ssm.model.PatchGroupPatchBaselineMappingListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePatchGroupsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribePatchGroupsResponse> {
    private static final SdkField<List<PatchGroupPatchBaselineMapping>> MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribePatchGroupsResponse.getter(DescribePatchGroupsResponse::mappings)).setter(DescribePatchGroupsResponse.setter(Builder::mappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PatchGroupPatchBaselineMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribePatchGroupsResponse.getter(DescribePatchGroupsResponse::nextToken)).setter(DescribePatchGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAPPINGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PatchGroupPatchBaselineMapping> mappings;
    private final String nextToken;

    private DescribePatchGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.mappings = builder.mappings;
        this.nextToken = builder.nextToken;
    }

    public List<PatchGroupPatchBaselineMapping> mappings() {
        return this.mappings;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchGroupsResponse)) {
            return false;
        }
        DescribePatchGroupsResponse other = (DescribePatchGroupsResponse)((Object)obj);
        return Objects.equals(this.mappings(), other.mappings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribePatchGroupsResponse").add("Mappings", this.mappings()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mappings": {
                return Optional.ofNullable(clazz.cast(this.mappings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePatchGroupsResponse, T> g) {
        return obj -> g.apply((DescribePatchGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<PatchGroupPatchBaselineMapping> mappings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchGroupsResponse model) {
            super(model);
            this.mappings(model.mappings);
            this.nextToken(model.nextToken);
        }

        public final Collection<PatchGroupPatchBaselineMapping.Builder> getMappings() {
            return this.mappings != null ? (Collection)this.mappings.stream().map(PatchGroupPatchBaselineMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mappings(Collection<PatchGroupPatchBaselineMapping> mappings) {
            this.mappings = PatchGroupPatchBaselineMappingListCopier.copy(mappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappings(PatchGroupPatchBaselineMapping ... mappings) {
            this.mappings(Arrays.asList(mappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappings(Consumer<PatchGroupPatchBaselineMapping.Builder> ... mappings) {
            this.mappings(Stream.of(mappings).map(c -> (PatchGroupPatchBaselineMapping)((PatchGroupPatchBaselineMapping.Builder)PatchGroupPatchBaselineMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMappings(Collection<PatchGroupPatchBaselineMapping.BuilderImpl> mappings) {
            this.mappings = PatchGroupPatchBaselineMappingListCopier.copyFromBuilder(mappings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePatchGroupsResponse build() {
            return new DescribePatchGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePatchGroupsResponse> {
        public Builder mappings(Collection<PatchGroupPatchBaselineMapping> var1);

        public Builder mappings(PatchGroupPatchBaselineMapping ... var1);

        public Builder mappings(Consumer<PatchGroupPatchBaselineMapping.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

