/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.PatchComplianceDataState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatchComplianceData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PatchComplianceData> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PatchComplianceData.getter(PatchComplianceData::title)).setter(PatchComplianceData.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> KB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PatchComplianceData.getter(PatchComplianceData::kbId)).setter(PatchComplianceData.setter(Builder::kbId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KBId").build()}).build();
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PatchComplianceData.getter(PatchComplianceData::classification)).setter(PatchComplianceData.setter(Builder::classification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PatchComplianceData.getter(PatchComplianceData::severity)).setter(PatchComplianceData.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PatchComplianceData.getter(PatchComplianceData::stateAsString)).setter(PatchComplianceData.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> INSTALLED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PatchComplianceData.getter(PatchComplianceData::installedTime)).setter(PatchComplianceData.setter(Builder::installedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstalledTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, KB_ID_FIELD, CLASSIFICATION_FIELD, SEVERITY_FIELD, STATE_FIELD, INSTALLED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String kbId;
    private final String classification;
    private final String severity;
    private final String state;
    private final Instant installedTime;

    private PatchComplianceData(BuilderImpl builder) {
        this.title = builder.title;
        this.kbId = builder.kbId;
        this.classification = builder.classification;
        this.severity = builder.severity;
        this.state = builder.state;
        this.installedTime = builder.installedTime;
    }

    public String title() {
        return this.title;
    }

    public String kbId() {
        return this.kbId;
    }

    public String classification() {
        return this.classification;
    }

    public String severity() {
        return this.severity;
    }

    public PatchComplianceDataState state() {
        return PatchComplianceDataState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Instant installedTime() {
        return this.installedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.kbId());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.installedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchComplianceData)) {
            return false;
        }
        PatchComplianceData other = (PatchComplianceData)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.kbId(), other.kbId()) && Objects.equals(this.classification(), other.classification()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.installedTime(), other.installedTime());
    }

    public String toString() {
        return ToString.builder((String)"PatchComplianceData").add("Title", (Object)this.title()).add("KBId", (Object)this.kbId()).add("Classification", (Object)this.classification()).add("Severity", (Object)this.severity()).add("State", (Object)this.stateAsString()).add("InstalledTime", (Object)this.installedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "KBId": {
                return Optional.ofNullable(clazz.cast(this.kbId()));
            }
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "InstalledTime": {
                return Optional.ofNullable(clazz.cast(this.installedTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchComplianceData, T> g) {
        return obj -> g.apply((PatchComplianceData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String kbId;
        private String classification;
        private String severity;
        private String state;
        private Instant installedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchComplianceData model) {
            this.title(model.title);
            this.kbId(model.kbId);
            this.classification(model.classification);
            this.severity(model.severity);
            this.state(model.state);
            this.installedTime(model.installedTime);
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getKbId() {
            return this.kbId;
        }

        @Override
        public final Builder kbId(String kbId) {
            this.kbId = kbId;
            return this;
        }

        public final void setKbId(String kbId) {
            this.kbId = kbId;
        }

        public final String getClassification() {
            return this.classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PatchComplianceDataState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getInstalledTime() {
            return this.installedTime;
        }

        @Override
        public final Builder installedTime(Instant installedTime) {
            this.installedTime = installedTime;
            return this;
        }

        public final void setInstalledTime(Instant installedTime) {
            this.installedTime = installedTime;
        }

        public PatchComplianceData build() {
            return new PatchComplianceData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PatchComplianceData> {
        public Builder title(String var1);

        public Builder kbId(String var1);

        public Builder classification(String var1);

        public Builder severity(String var1);

        public Builder state(String var1);

        public Builder state(PatchComplianceDataState var1);

        public Builder installedTime(Instant var1);
    }
}

