/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.PatchComplianceLevel;
import software.amazon.awssdk.services.ssm.model.PatchFilterGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatchRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PatchRule> {
    private static final SdkField<PatchFilterGroup> PATCH_FILTER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PatchRule.getter(PatchRule::patchFilterGroup)).setter(PatchRule.setter(Builder::patchFilterGroup)).constructor(PatchFilterGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchFilterGroup").build()}).build();
    private static final SdkField<String> COMPLIANCE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PatchRule.getter(PatchRule::complianceLevelAsString)).setter(PatchRule.setter(Builder::complianceLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceLevel").build()}).build();
    private static final SdkField<Integer> APPROVE_AFTER_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PatchRule.getter(PatchRule::approveAfterDays)).setter(PatchRule.setter(Builder::approveAfterDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproveAfterDays").build()}).build();
    private static final SdkField<Boolean> ENABLE_NON_SECURITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PatchRule.getter(PatchRule::enableNonSecurity)).setter(PatchRule.setter(Builder::enableNonSecurity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNonSecurity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCH_FILTER_GROUP_FIELD, COMPLIANCE_LEVEL_FIELD, APPROVE_AFTER_DAYS_FIELD, ENABLE_NON_SECURITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final PatchFilterGroup patchFilterGroup;
    private final String complianceLevel;
    private final Integer approveAfterDays;
    private final Boolean enableNonSecurity;

    private PatchRule(BuilderImpl builder) {
        this.patchFilterGroup = builder.patchFilterGroup;
        this.complianceLevel = builder.complianceLevel;
        this.approveAfterDays = builder.approveAfterDays;
        this.enableNonSecurity = builder.enableNonSecurity;
    }

    public PatchFilterGroup patchFilterGroup() {
        return this.patchFilterGroup;
    }

    public PatchComplianceLevel complianceLevel() {
        return PatchComplianceLevel.fromValue(this.complianceLevel);
    }

    public String complianceLevelAsString() {
        return this.complianceLevel;
    }

    public Integer approveAfterDays() {
        return this.approveAfterDays;
    }

    public Boolean enableNonSecurity() {
        return this.enableNonSecurity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.patchFilterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.approveAfterDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNonSecurity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchRule)) {
            return false;
        }
        PatchRule other = (PatchRule)obj;
        return Objects.equals(this.patchFilterGroup(), other.patchFilterGroup()) && Objects.equals(this.complianceLevelAsString(), other.complianceLevelAsString()) && Objects.equals(this.approveAfterDays(), other.approveAfterDays()) && Objects.equals(this.enableNonSecurity(), other.enableNonSecurity());
    }

    public String toString() {
        return ToString.builder((String)"PatchRule").add("PatchFilterGroup", (Object)this.patchFilterGroup()).add("ComplianceLevel", (Object)this.complianceLevelAsString()).add("ApproveAfterDays", (Object)this.approveAfterDays()).add("EnableNonSecurity", (Object)this.enableNonSecurity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PatchFilterGroup": {
                return Optional.ofNullable(clazz.cast(this.patchFilterGroup()));
            }
            case "ComplianceLevel": {
                return Optional.ofNullable(clazz.cast(this.complianceLevelAsString()));
            }
            case "ApproveAfterDays": {
                return Optional.ofNullable(clazz.cast(this.approveAfterDays()));
            }
            case "EnableNonSecurity": {
                return Optional.ofNullable(clazz.cast(this.enableNonSecurity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchRule, T> g) {
        return obj -> g.apply((PatchRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PatchFilterGroup patchFilterGroup;
        private String complianceLevel;
        private Integer approveAfterDays;
        private Boolean enableNonSecurity;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchRule model) {
            this.patchFilterGroup(model.patchFilterGroup);
            this.complianceLevel(model.complianceLevel);
            this.approveAfterDays(model.approveAfterDays);
            this.enableNonSecurity(model.enableNonSecurity);
        }

        public final PatchFilterGroup.Builder getPatchFilterGroup() {
            return this.patchFilterGroup != null ? this.patchFilterGroup.toBuilder() : null;
        }

        @Override
        public final Builder patchFilterGroup(PatchFilterGroup patchFilterGroup) {
            this.patchFilterGroup = patchFilterGroup;
            return this;
        }

        public final void setPatchFilterGroup(PatchFilterGroup.BuilderImpl patchFilterGroup) {
            this.patchFilterGroup = patchFilterGroup != null ? patchFilterGroup.build() : null;
        }

        public final String getComplianceLevelAsString() {
            return this.complianceLevel;
        }

        @Override
        public final Builder complianceLevel(String complianceLevel) {
            this.complianceLevel = complianceLevel;
            return this;
        }

        @Override
        public final Builder complianceLevel(PatchComplianceLevel complianceLevel) {
            this.complianceLevel(complianceLevel.toString());
            return this;
        }

        public final void setComplianceLevel(String complianceLevel) {
            this.complianceLevel = complianceLevel;
        }

        public final Integer getApproveAfterDays() {
            return this.approveAfterDays;
        }

        @Override
        public final Builder approveAfterDays(Integer approveAfterDays) {
            this.approveAfterDays = approveAfterDays;
            return this;
        }

        public final void setApproveAfterDays(Integer approveAfterDays) {
            this.approveAfterDays = approveAfterDays;
        }

        public final Boolean getEnableNonSecurity() {
            return this.enableNonSecurity;
        }

        @Override
        public final Builder enableNonSecurity(Boolean enableNonSecurity) {
            this.enableNonSecurity = enableNonSecurity;
            return this;
        }

        public final void setEnableNonSecurity(Boolean enableNonSecurity) {
            this.enableNonSecurity = enableNonSecurity;
        }

        public PatchRule build() {
            return new PatchRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PatchRule> {
        public Builder patchFilterGroup(PatchFilterGroup var1);

        default public Builder patchFilterGroup(Consumer<PatchFilterGroup.Builder> patchFilterGroup) {
            return this.patchFilterGroup((PatchFilterGroup)((PatchFilterGroup.Builder)PatchFilterGroup.builder().applyMutation(patchFilterGroup)).build());
        }

        public Builder complianceLevel(String var1);

        public Builder complianceLevel(PatchComplianceLevel var1);

        public Builder approveAfterDays(Integer var1);

        public Builder enableNonSecurity(Boolean var1);
    }
}

