/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePatchGroupStateResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribePatchGroupStateResponse> {
    private static final SdkField<Integer> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instances)).setter(DescribePatchGroupStateResponse.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_INSTALLED_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithInstalledPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithInstalledPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithInstalledPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_INSTALLED_OTHER_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithInstalledOtherPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithInstalledOtherPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithInstalledOtherPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_INSTALLED_REJECTED_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithInstalledRejectedPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithInstalledRejectedPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithInstalledRejectedPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_MISSING_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithMissingPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithMissingPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithMissingPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_FAILED_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithFailedPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithFailedPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithFailedPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_NOT_APPLICABLE_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithNotApplicablePatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithNotApplicablePatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithNotApplicablePatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_UNREPORTED_NOT_APPLICABLE_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithUnreportedNotApplicablePatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithUnreportedNotApplicablePatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithUnreportedNotApplicablePatches").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD, INSTANCES_WITH_INSTALLED_PATCHES_FIELD, INSTANCES_WITH_INSTALLED_OTHER_PATCHES_FIELD, INSTANCES_WITH_INSTALLED_REJECTED_PATCHES_FIELD, INSTANCES_WITH_MISSING_PATCHES_FIELD, INSTANCES_WITH_FAILED_PATCHES_FIELD, INSTANCES_WITH_NOT_APPLICABLE_PATCHES_FIELD, INSTANCES_WITH_UNREPORTED_NOT_APPLICABLE_PATCHES_FIELD));
    private final Integer instances;
    private final Integer instancesWithInstalledPatches;
    private final Integer instancesWithInstalledOtherPatches;
    private final Integer instancesWithInstalledRejectedPatches;
    private final Integer instancesWithMissingPatches;
    private final Integer instancesWithFailedPatches;
    private final Integer instancesWithNotApplicablePatches;
    private final Integer instancesWithUnreportedNotApplicablePatches;

    private DescribePatchGroupStateResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.instancesWithInstalledPatches = builder.instancesWithInstalledPatches;
        this.instancesWithInstalledOtherPatches = builder.instancesWithInstalledOtherPatches;
        this.instancesWithInstalledRejectedPatches = builder.instancesWithInstalledRejectedPatches;
        this.instancesWithMissingPatches = builder.instancesWithMissingPatches;
        this.instancesWithFailedPatches = builder.instancesWithFailedPatches;
        this.instancesWithNotApplicablePatches = builder.instancesWithNotApplicablePatches;
        this.instancesWithUnreportedNotApplicablePatches = builder.instancesWithUnreportedNotApplicablePatches;
    }

    public Integer instances() {
        return this.instances;
    }

    public Integer instancesWithInstalledPatches() {
        return this.instancesWithInstalledPatches;
    }

    public Integer instancesWithInstalledOtherPatches() {
        return this.instancesWithInstalledOtherPatches;
    }

    public Integer instancesWithInstalledRejectedPatches() {
        return this.instancesWithInstalledRejectedPatches;
    }

    public Integer instancesWithMissingPatches() {
        return this.instancesWithMissingPatches;
    }

    public Integer instancesWithFailedPatches() {
        return this.instancesWithFailedPatches;
    }

    public Integer instancesWithNotApplicablePatches() {
        return this.instancesWithNotApplicablePatches;
    }

    public Integer instancesWithUnreportedNotApplicablePatches() {
        return this.instancesWithUnreportedNotApplicablePatches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithInstalledPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithInstalledOtherPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithInstalledRejectedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithMissingPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithFailedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithNotApplicablePatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithUnreportedNotApplicablePatches());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchGroupStateResponse)) {
            return false;
        }
        DescribePatchGroupStateResponse other = (DescribePatchGroupStateResponse)((Object)obj);
        return Objects.equals(this.instances(), other.instances()) && Objects.equals(this.instancesWithInstalledPatches(), other.instancesWithInstalledPatches()) && Objects.equals(this.instancesWithInstalledOtherPatches(), other.instancesWithInstalledOtherPatches()) && Objects.equals(this.instancesWithInstalledRejectedPatches(), other.instancesWithInstalledRejectedPatches()) && Objects.equals(this.instancesWithMissingPatches(), other.instancesWithMissingPatches()) && Objects.equals(this.instancesWithFailedPatches(), other.instancesWithFailedPatches()) && Objects.equals(this.instancesWithNotApplicablePatches(), other.instancesWithNotApplicablePatches()) && Objects.equals(this.instancesWithUnreportedNotApplicablePatches(), other.instancesWithUnreportedNotApplicablePatches());
    }

    public String toString() {
        return ToString.builder((String)"DescribePatchGroupStateResponse").add("Instances", (Object)this.instances()).add("InstancesWithInstalledPatches", (Object)this.instancesWithInstalledPatches()).add("InstancesWithInstalledOtherPatches", (Object)this.instancesWithInstalledOtherPatches()).add("InstancesWithInstalledRejectedPatches", (Object)this.instancesWithInstalledRejectedPatches()).add("InstancesWithMissingPatches", (Object)this.instancesWithMissingPatches()).add("InstancesWithFailedPatches", (Object)this.instancesWithFailedPatches()).add("InstancesWithNotApplicablePatches", (Object)this.instancesWithNotApplicablePatches()).add("InstancesWithUnreportedNotApplicablePatches", (Object)this.instancesWithUnreportedNotApplicablePatches()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "InstancesWithInstalledPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithInstalledPatches()));
            }
            case "InstancesWithInstalledOtherPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithInstalledOtherPatches()));
            }
            case "InstancesWithInstalledRejectedPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithInstalledRejectedPatches()));
            }
            case "InstancesWithMissingPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithMissingPatches()));
            }
            case "InstancesWithFailedPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithFailedPatches()));
            }
            case "InstancesWithNotApplicablePatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithNotApplicablePatches()));
            }
            case "InstancesWithUnreportedNotApplicablePatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithUnreportedNotApplicablePatches()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePatchGroupStateResponse, T> g) {
        return obj -> g.apply((DescribePatchGroupStateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private Integer instances;
        private Integer instancesWithInstalledPatches;
        private Integer instancesWithInstalledOtherPatches;
        private Integer instancesWithInstalledRejectedPatches;
        private Integer instancesWithMissingPatches;
        private Integer instancesWithFailedPatches;
        private Integer instancesWithNotApplicablePatches;
        private Integer instancesWithUnreportedNotApplicablePatches;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchGroupStateResponse model) {
            super(model);
            this.instances(model.instances);
            this.instancesWithInstalledPatches(model.instancesWithInstalledPatches);
            this.instancesWithInstalledOtherPatches(model.instancesWithInstalledOtherPatches);
            this.instancesWithInstalledRejectedPatches(model.instancesWithInstalledRejectedPatches);
            this.instancesWithMissingPatches(model.instancesWithMissingPatches);
            this.instancesWithFailedPatches(model.instancesWithFailedPatches);
            this.instancesWithNotApplicablePatches(model.instancesWithNotApplicablePatches);
            this.instancesWithUnreportedNotApplicablePatches(model.instancesWithUnreportedNotApplicablePatches);
        }

        public final Integer getInstances() {
            return this.instances;
        }

        @Override
        public final Builder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public final void setInstances(Integer instances) {
            this.instances = instances;
        }

        public final Integer getInstancesWithInstalledPatches() {
            return this.instancesWithInstalledPatches;
        }

        @Override
        public final Builder instancesWithInstalledPatches(Integer instancesWithInstalledPatches) {
            this.instancesWithInstalledPatches = instancesWithInstalledPatches;
            return this;
        }

        public final void setInstancesWithInstalledPatches(Integer instancesWithInstalledPatches) {
            this.instancesWithInstalledPatches = instancesWithInstalledPatches;
        }

        public final Integer getInstancesWithInstalledOtherPatches() {
            return this.instancesWithInstalledOtherPatches;
        }

        @Override
        public final Builder instancesWithInstalledOtherPatches(Integer instancesWithInstalledOtherPatches) {
            this.instancesWithInstalledOtherPatches = instancesWithInstalledOtherPatches;
            return this;
        }

        public final void setInstancesWithInstalledOtherPatches(Integer instancesWithInstalledOtherPatches) {
            this.instancesWithInstalledOtherPatches = instancesWithInstalledOtherPatches;
        }

        public final Integer getInstancesWithInstalledRejectedPatches() {
            return this.instancesWithInstalledRejectedPatches;
        }

        @Override
        public final Builder instancesWithInstalledRejectedPatches(Integer instancesWithInstalledRejectedPatches) {
            this.instancesWithInstalledRejectedPatches = instancesWithInstalledRejectedPatches;
            return this;
        }

        public final void setInstancesWithInstalledRejectedPatches(Integer instancesWithInstalledRejectedPatches) {
            this.instancesWithInstalledRejectedPatches = instancesWithInstalledRejectedPatches;
        }

        public final Integer getInstancesWithMissingPatches() {
            return this.instancesWithMissingPatches;
        }

        @Override
        public final Builder instancesWithMissingPatches(Integer instancesWithMissingPatches) {
            this.instancesWithMissingPatches = instancesWithMissingPatches;
            return this;
        }

        public final void setInstancesWithMissingPatches(Integer instancesWithMissingPatches) {
            this.instancesWithMissingPatches = instancesWithMissingPatches;
        }

        public final Integer getInstancesWithFailedPatches() {
            return this.instancesWithFailedPatches;
        }

        @Override
        public final Builder instancesWithFailedPatches(Integer instancesWithFailedPatches) {
            this.instancesWithFailedPatches = instancesWithFailedPatches;
            return this;
        }

        public final void setInstancesWithFailedPatches(Integer instancesWithFailedPatches) {
            this.instancesWithFailedPatches = instancesWithFailedPatches;
        }

        public final Integer getInstancesWithNotApplicablePatches() {
            return this.instancesWithNotApplicablePatches;
        }

        @Override
        public final Builder instancesWithNotApplicablePatches(Integer instancesWithNotApplicablePatches) {
            this.instancesWithNotApplicablePatches = instancesWithNotApplicablePatches;
            return this;
        }

        public final void setInstancesWithNotApplicablePatches(Integer instancesWithNotApplicablePatches) {
            this.instancesWithNotApplicablePatches = instancesWithNotApplicablePatches;
        }

        public final Integer getInstancesWithUnreportedNotApplicablePatches() {
            return this.instancesWithUnreportedNotApplicablePatches;
        }

        @Override
        public final Builder instancesWithUnreportedNotApplicablePatches(Integer instancesWithUnreportedNotApplicablePatches) {
            this.instancesWithUnreportedNotApplicablePatches = instancesWithUnreportedNotApplicablePatches;
            return this;
        }

        public final void setInstancesWithUnreportedNotApplicablePatches(Integer instancesWithUnreportedNotApplicablePatches) {
            this.instancesWithUnreportedNotApplicablePatches = instancesWithUnreportedNotApplicablePatches;
        }

        @Override
        public DescribePatchGroupStateResponse build() {
            return new DescribePatchGroupStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePatchGroupStateResponse> {
        public Builder instances(Integer var1);

        public Builder instancesWithInstalledPatches(Integer var1);

        public Builder instancesWithInstalledOtherPatches(Integer var1);

        public Builder instancesWithInstalledRejectedPatches(Integer var1);

        public Builder instancesWithMissingPatches(Integer var1);

        public Builder instancesWithFailedPatches(Integer var1);

        public Builder instancesWithNotApplicablePatches(Integer var1);

        public Builder instancesWithUnreportedNotApplicablePatches(Integer var1);
    }
}

