/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DocumentVersionInfo;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse;

public class ListDocumentVersionsPublisher
implements SdkPublisher<ListDocumentVersionsResponse> {
    private final SsmAsyncClient client;
    private final ListDocumentVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDocumentVersionsPublisher(SsmAsyncClient client, ListDocumentVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDocumentVersionsPublisher(SsmAsyncClient client, ListDocumentVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDocumentVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDocumentVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DocumentVersionInfo> documentVersions() {
        return this.flatMapIterable(response -> response.documentVersions());
    }

    private class ListDocumentVersionsResponseFetcher
    implements AsyncPageFetcher<ListDocumentVersionsResponse> {
        private ListDocumentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDocumentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDocumentVersionsResponse> nextPage(ListDocumentVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListDocumentVersionsPublisher.this.client.listDocumentVersions(ListDocumentVersionsPublisher.this.firstRequest);
            }
            return ListDocumentVersionsPublisher.this.client.listDocumentVersions((ListDocumentVersionsRequest)((Object)ListDocumentVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

