/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.ComplianceItem;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse;

public class ListComplianceItemsPublisher
implements SdkPublisher<ListComplianceItemsResponse> {
    private final SsmAsyncClient client;
    private final ListComplianceItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComplianceItemsPublisher(SsmAsyncClient client, ListComplianceItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComplianceItemsPublisher(SsmAsyncClient client, ListComplianceItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComplianceItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComplianceItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ComplianceItem> complianceItems() {
        return this.flatMapIterable(response -> response.complianceItems());
    }

    private class ListComplianceItemsResponseFetcher
    implements AsyncPageFetcher<ListComplianceItemsResponse> {
        private ListComplianceItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListComplianceItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComplianceItemsResponse> nextPage(ListComplianceItemsResponse previousPage) {
            if (previousPage == null) {
                return ListComplianceItemsPublisher.this.client.listComplianceItems(ListComplianceItemsPublisher.this.firstRequest);
            }
            return ListComplianceItemsPublisher.this.client.listComplianceItems((ListComplianceItemsRequest)((Object)ListComplianceItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

