/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse;
import software.amazon.awssdk.services.ssm.model.OpsEntity;

public class GetOpsSummaryIterable
implements SdkIterable<GetOpsSummaryResponse> {
    private final SsmClient client;
    private final GetOpsSummaryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetOpsSummaryIterable(SsmClient client, GetOpsSummaryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetOpsSummaryResponseFetcher();
    }

    public Iterator<GetOpsSummaryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OpsEntity> entities() {
        Function<GetOpsSummaryResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetOpsSummaryResponseFetcher
    implements SyncPageFetcher<GetOpsSummaryResponse> {
        private GetOpsSummaryResponseFetcher() {
        }

        public boolean hasNextPage(GetOpsSummaryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetOpsSummaryResponse nextPage(GetOpsSummaryResponse previousPage) {
            if (previousPage == null) {
                return GetOpsSummaryIterable.this.client.getOpsSummary(GetOpsSummaryIterable.this.firstRequest);
            }
            return GetOpsSummaryIterable.this.client.getOpsSummary((GetOpsSummaryRequest)((Object)GetOpsSummaryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

