/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey;
import software.amazon.awssdk.services.ssm.model.InstancePropertyFilterValueSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstancePropertyFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstancePropertyFilter> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(InstancePropertyFilter.getter(InstancePropertyFilter::keyAsString)).setter(InstancePropertyFilter.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<List<String>> VALUE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("valueSet").getter(InstancePropertyFilter.getter(InstancePropertyFilter::valueSet)).setter(InstancePropertyFilter.setter(Builder::valueSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_SET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstancePropertyFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String key;
    private final List<String> valueSet;

    private InstancePropertyFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.valueSet = builder.valueSet;
    }

    public final InstancePropertyFilterKey key() {
        return InstancePropertyFilterKey.fromValue(this.key);
    }

    public final String keyAsString() {
        return this.key;
    }

    public final boolean hasValueSet() {
        return this.valueSet != null && !(this.valueSet instanceof SdkAutoConstructList);
    }

    public final List<String> valueSet() {
        return this.valueSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValueSet() ? this.valueSet() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePropertyFilter)) {
            return false;
        }
        InstancePropertyFilter other = (InstancePropertyFilter)obj;
        return Objects.equals(this.keyAsString(), other.keyAsString()) && this.hasValueSet() == other.hasValueSet() && Objects.equals(this.valueSet(), other.valueSet());
    }

    public final String toString() {
        return ToString.builder((String)"InstancePropertyFilter").add("Key", (Object)this.keyAsString()).add("ValueSet", this.hasValueSet() ? this.valueSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.ofNullable(clazz.cast(this.keyAsString()));
            }
            case "valueSet": {
                return Optional.ofNullable(clazz.cast(this.valueSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", KEY_FIELD);
        map.put("valueSet", VALUE_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstancePropertyFilter, T> g) {
        return obj -> g.apply((InstancePropertyFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> valueSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePropertyFilter model) {
            this.key(model.key);
            this.valueSet(model.valueSet);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(InstancePropertyFilterKey key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final Collection<String> getValueSet() {
            if (this.valueSet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.valueSet;
        }

        public final void setValueSet(Collection<String> valueSet) {
            this.valueSet = InstancePropertyFilterValueSetCopier.copy(valueSet);
        }

        @Override
        public final Builder valueSet(Collection<String> valueSet) {
            this.valueSet = InstancePropertyFilterValueSetCopier.copy(valueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueSet(String ... valueSet) {
            this.valueSet(Arrays.asList(valueSet));
            return this;
        }

        public InstancePropertyFilter build() {
            return new InstancePropertyFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstancePropertyFilter> {
        public Builder key(String var1);

        public Builder key(InstancePropertyFilterKey var1);

        public Builder valueSet(Collection<String> var1);

        public Builder valueSet(String ... var1);
    }
}

