/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse;

public class DescribePatchPropertiesPublisher
implements SdkPublisher<DescribePatchPropertiesResponse> {
    private final SsmAsyncClient client;
    private final DescribePatchPropertiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePatchPropertiesPublisher(SsmAsyncClient client, DescribePatchPropertiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePatchPropertiesPublisher(SsmAsyncClient client, DescribePatchPropertiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePatchPropertiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePatchPropertiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Map<String, String>> properties() {
        return this.flatMapIterable(response -> response.properties());
    }

    private class DescribePatchPropertiesResponseFetcher
    implements AsyncPageFetcher<DescribePatchPropertiesResponse> {
        private DescribePatchPropertiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePatchPropertiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePatchPropertiesResponse> nextPage(DescribePatchPropertiesResponse previousPage) {
            if (previousPage == null) {
                return DescribePatchPropertiesPublisher.this.client.describePatchProperties(DescribePatchPropertiesPublisher.this.firstRequest);
            }
            return DescribePatchPropertiesPublisher.this.client.describePatchProperties((DescribePatchPropertiesRequest)((Object)DescribePatchPropertiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

