/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.NodeOwnerInfo;
import software.amazon.awssdk.services.ssm.model.NodeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Node
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Node> {
    private static final SdkField<Instant> CAPTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CaptureTime").getter(Node.getter(Node::captureTime)).setter(Node.setter(Builder::captureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureTime").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Node.getter(Node::id)).setter(Node.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<NodeOwnerInfo> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Owner").getter(Node.getter(Node::owner)).setter(Node.setter(Builder::owner)).constructor(NodeOwnerInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(Node.getter(Node::region)).setter(Node.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<NodeType> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NodeType").getter(Node.getter(Node::nodeType)).setter(Node.setter(Builder::nodeType)).constructor(NodeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTURE_TIME_FIELD, ID_FIELD, OWNER_FIELD, REGION_FIELD, NODE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Node.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant captureTime;
    private final String id;
    private final NodeOwnerInfo owner;
    private final String region;
    private final NodeType nodeType;

    private Node(BuilderImpl builder) {
        this.captureTime = builder.captureTime;
        this.id = builder.id;
        this.owner = builder.owner;
        this.region = builder.region;
        this.nodeType = builder.nodeType;
    }

    public final Instant captureTime() {
        return this.captureTime;
    }

    public final String id() {
        return this.id;
    }

    public final NodeOwnerInfo owner() {
        return this.owner;
    }

    public final String region() {
        return this.region;
    }

    public final NodeType nodeType() {
        return this.nodeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.captureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return Objects.equals(this.captureTime(), other.captureTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.nodeType(), other.nodeType());
    }

    public final String toString() {
        return ToString.builder((String)"Node").add("CaptureTime", (Object)this.captureTime()).add("Id", (Object)this.id()).add("Owner", (Object)this.owner()).add("Region", (Object)this.region()).add("NodeType", (Object)this.nodeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CaptureTime": {
                return Optional.ofNullable(clazz.cast(this.captureTime()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CaptureTime", CAPTURE_TIME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant captureTime;
        private String id;
        private NodeOwnerInfo owner;
        private String region;
        private NodeType nodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            this.captureTime(model.captureTime);
            this.id(model.id);
            this.owner(model.owner);
            this.region(model.region);
            this.nodeType(model.nodeType);
        }

        public final Instant getCaptureTime() {
            return this.captureTime;
        }

        public final void setCaptureTime(Instant captureTime) {
            this.captureTime = captureTime;
        }

        @Override
        public final Builder captureTime(Instant captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final NodeOwnerInfo.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        public final void setOwner(NodeOwnerInfo.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public final Builder owner(NodeOwnerInfo owner) {
            this.owner = owner;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final NodeType.Builder getNodeType() {
            return this.nodeType != null ? this.nodeType.toBuilder() : null;
        }

        public final void setNodeType(NodeType.BuilderImpl nodeType) {
            this.nodeType = nodeType != null ? nodeType.build() : null;
        }

        @Override
        public final Builder nodeType(NodeType nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public Node build() {
            return new Node(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Node> {
        public Builder captureTime(Instant var1);

        public Builder id(String var1);

        public Builder owner(NodeOwnerInfo var1);

        default public Builder owner(Consumer<NodeOwnerInfo.Builder> owner) {
            return this.owner((NodeOwnerInfo)((NodeOwnerInfo.Builder)NodeOwnerInfo.builder().applyMutation(owner)).build());
        }

        public Builder region(String var1);

        public Builder nodeType(NodeType var1);

        default public Builder nodeType(Consumer<NodeType.Builder> nodeType) {
            return this.nodeType((NodeType)((NodeType.Builder)NodeType.builder().applyMutation(nodeType)).build());
        }
    }
}

