/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeployablePatchSnapshotForInstanceRequest extends SsmRequest implements
        ToCopyableBuilder<GetDeployablePatchSnapshotForInstanceRequest.Builder, GetDeployablePatchSnapshotForInstanceRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(GetDeployablePatchSnapshotForInstanceRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(GetDeployablePatchSnapshotForInstanceRequest::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<BaselineOverride> BASELINE_OVERRIDE_FIELD = SdkField
            .<BaselineOverride> builder(MarshallingType.SDK_POJO).memberName("BaselineOverride")
            .getter(getter(GetDeployablePatchSnapshotForInstanceRequest::baselineOverride))
            .setter(setter(Builder::baselineOverride)).constructor(BaselineOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineOverride").build()).build();

    private static final SdkField<Boolean> USE_S3_DUAL_STACK_ENDPOINT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseS3DualStackEndpoint")
            .getter(getter(GetDeployablePatchSnapshotForInstanceRequest::useS3DualStackEndpoint))
            .setter(setter(Builder::useS3DualStackEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseS3DualStackEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            SNAPSHOT_ID_FIELD, BASELINE_OVERRIDE_FIELD, USE_S3_DUAL_STACK_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String snapshotId;

    private final BaselineOverride baselineOverride;

    private final Boolean useS3DualStackEndpoint;

    private GetDeployablePatchSnapshotForInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.snapshotId = builder.snapshotId;
        this.baselineOverride = builder.baselineOverride;
        this.useS3DualStackEndpoint = builder.useS3DualStackEndpoint;
    }

    /**
     * <p>
     * The ID of the managed node for which the appropriate patch snapshot should be retrieved.
     * </p>
     * 
     * @return The ID of the managed node for which the appropriate patch snapshot should be retrieved.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The snapshot ID provided by the user when running <code>AWS-RunPatchBaseline</code>.
     * </p>
     * 
     * @return The snapshot ID provided by the user when running <code>AWS-RunPatchBaseline</code>.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * Defines the basic information about a patch baseline override.
     * </p>
     * 
     * @return Defines the basic information about a patch baseline override.
     */
    public final BaselineOverride baselineOverride() {
        return baselineOverride;
    }

    /**
     * <p>
     * Specifies whether to use S3 dualstack endpoints for the patch snapshot download URL. Set to <code>true</code> to
     * receive a presigned URL that supports both IPv4 and IPv6 connectivity. Set to <code>false</code> to use standard
     * IPv4-only endpoints. Default is <code>false</code>. This parameter is required for managed nodes in IPv6-only
     * environments.
     * </p>
     * 
     * @return Specifies whether to use S3 dualstack endpoints for the patch snapshot download URL. Set to
     *         <code>true</code> to receive a presigned URL that supports both IPv4 and IPv6 connectivity. Set to
     *         <code>false</code> to use standard IPv4-only endpoints. Default is <code>false</code>. This parameter is
     *         required for managed nodes in IPv6-only environments.
     */
    public final Boolean useS3DualStackEndpoint() {
        return useS3DualStackEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(baselineOverride());
        hashCode = 31 * hashCode + Objects.hashCode(useS3DualStackEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeployablePatchSnapshotForInstanceRequest)) {
            return false;
        }
        GetDeployablePatchSnapshotForInstanceRequest other = (GetDeployablePatchSnapshotForInstanceRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(baselineOverride(), other.baselineOverride())
                && Objects.equals(useS3DualStackEndpoint(), other.useS3DualStackEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeployablePatchSnapshotForInstanceRequest").add("InstanceId", instanceId())
                .add("SnapshotId", snapshotId()).add("BaselineOverride", baselineOverride())
                .add("UseS3DualStackEndpoint", useS3DualStackEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "BaselineOverride":
            return Optional.ofNullable(clazz.cast(baselineOverride()));
        case "UseS3DualStackEndpoint":
            return Optional.ofNullable(clazz.cast(useS3DualStackEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("BaselineOverride", BASELINE_OVERRIDE_FIELD);
        map.put("UseS3DualStackEndpoint", USE_S3_DUAL_STACK_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeployablePatchSnapshotForInstanceRequest, T> g) {
        return obj -> g.apply((GetDeployablePatchSnapshotForInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceRequest> {
        /**
         * <p>
         * The ID of the managed node for which the appropriate patch snapshot should be retrieved.
         * </p>
         * 
         * @param instanceId
         *        The ID of the managed node for which the appropriate patch snapshot should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The snapshot ID provided by the user when running <code>AWS-RunPatchBaseline</code>.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot ID provided by the user when running <code>AWS-RunPatchBaseline</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * Defines the basic information about a patch baseline override.
         * </p>
         * 
         * @param baselineOverride
         *        Defines the basic information about a patch baseline override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineOverride(BaselineOverride baselineOverride);

        /**
         * <p>
         * Defines the basic information about a patch baseline override.
         * </p>
         * This is a convenience method that creates an instance of the {@link BaselineOverride.Builder} avoiding the
         * need to create one manually via {@link BaselineOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BaselineOverride.Builder#build()} is called immediately and its
         * result is passed to {@link #baselineOverride(BaselineOverride)}.
         * 
         * @param baselineOverride
         *        a consumer that will call methods on {@link BaselineOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baselineOverride(BaselineOverride)
         */
        default Builder baselineOverride(Consumer<BaselineOverride.Builder> baselineOverride) {
            return baselineOverride(BaselineOverride.builder().applyMutation(baselineOverride).build());
        }

        /**
         * <p>
         * Specifies whether to use S3 dualstack endpoints for the patch snapshot download URL. Set to <code>true</code>
         * to receive a presigned URL that supports both IPv4 and IPv6 connectivity. Set to <code>false</code> to use
         * standard IPv4-only endpoints. Default is <code>false</code>. This parameter is required for managed nodes in
         * IPv6-only environments.
         * </p>
         * 
         * @param useS3DualStackEndpoint
         *        Specifies whether to use S3 dualstack endpoints for the patch snapshot download URL. Set to
         *        <code>true</code> to receive a presigned URL that supports both IPv4 and IPv6 connectivity. Set to
         *        <code>false</code> to use standard IPv4-only endpoints. Default is <code>false</code>. This parameter
         *        is required for managed nodes in IPv6-only environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useS3DualStackEndpoint(Boolean useS3DualStackEndpoint);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String snapshotId;

        private BaselineOverride baselineOverride;

        private Boolean useS3DualStackEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeployablePatchSnapshotForInstanceRequest model) {
            super(model);
            instanceId(model.instanceId);
            snapshotId(model.snapshotId);
            baselineOverride(model.baselineOverride);
            useS3DualStackEndpoint(model.useS3DualStackEndpoint);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final BaselineOverride.Builder getBaselineOverride() {
            return baselineOverride != null ? baselineOverride.toBuilder() : null;
        }

        public final void setBaselineOverride(BaselineOverride.BuilderImpl baselineOverride) {
            this.baselineOverride = baselineOverride != null ? baselineOverride.build() : null;
        }

        @Override
        public final Builder baselineOverride(BaselineOverride baselineOverride) {
            this.baselineOverride = baselineOverride;
            return this;
        }

        public final Boolean getUseS3DualStackEndpoint() {
            return useS3DualStackEndpoint;
        }

        public final void setUseS3DualStackEndpoint(Boolean useS3DualStackEndpoint) {
            this.useS3DualStackEndpoint = useS3DualStackEndpoint;
        }

        @Override
        public final Builder useS3DualStackEndpoint(Boolean useS3DualStackEndpoint) {
            this.useS3DualStackEndpoint = useS3DualStackEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDeployablePatchSnapshotForInstanceRequest build() {
            return new GetDeployablePatchSnapshotForInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
