/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.OpsItemDataValue;
import software.amazon.awssdk.services.ssm.model.OpsItemNotification;
import software.amazon.awssdk.services.ssm.model.OpsItemNotificationsCopier;
import software.amazon.awssdk.services.ssm.model.OpsItemOperationalDataCopier;
import software.amazon.awssdk.services.ssm.model.OpsItemStatus;
import software.amazon.awssdk.services.ssm.model.RelatedOpsItem;
import software.amazon.awssdk.services.ssm.model.RelatedOpsItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpsItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpsItem> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(OpsItem.getter(OpsItem::createdBy)).setter(OpsItem.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> OPS_ITEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemType").getter(OpsItem.getter(OpsItem::opsItemType)).setter(OpsItem.setter(Builder::opsItemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemType").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(OpsItem.getter(OpsItem::createdTime)).setter(OpsItem.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(OpsItem.getter(OpsItem::description)).setter(OpsItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(OpsItem.getter(OpsItem::lastModifiedBy)).setter(OpsItem.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(OpsItem.getter(OpsItem::lastModifiedTime)).setter(OpsItem.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<List<OpsItemNotification>> NOTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Notifications").getter(OpsItem.getter(OpsItem::notifications)).setter(OpsItem.setter(Builder::notifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(OpsItem.getter(OpsItem::priority)).setter(OpsItem.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<List<RelatedOpsItem>> RELATED_OPS_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedOpsItems").getter(OpsItem.getter(OpsItem::relatedOpsItems)).setter(OpsItem.setter(Builder::relatedOpsItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedOpsItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedOpsItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(OpsItem.getter(OpsItem::statusAsString)).setter(OpsItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemId").getter(OpsItem.getter(OpsItem::opsItemId)).setter(OpsItem.setter(Builder::opsItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(OpsItem.getter(OpsItem::version)).setter(OpsItem.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(OpsItem.getter(OpsItem::title)).setter(OpsItem.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(OpsItem.getter(OpsItem::source)).setter(OpsItem.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<Map<String, OpsItemDataValue>> OPERATIONAL_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OperationalData").getter(OpsItem.getter(OpsItem::operationalData)).setter(OpsItem.setter(Builder::operationalData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationalData").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemDataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(OpsItem.getter(OpsItem::category)).setter(OpsItem.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(OpsItem.getter(OpsItem::severity)).setter(OpsItem.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<Instant> ACTUAL_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActualStartTime").getter(OpsItem.getter(OpsItem::actualStartTime)).setter(OpsItem.setter(Builder::actualStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualStartTime").build()}).build();
    private static final SdkField<Instant> ACTUAL_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActualEndTime").getter(OpsItem.getter(OpsItem::actualEndTime)).setter(OpsItem.setter(Builder::actualEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualEndTime").build()}).build();
    private static final SdkField<Instant> PLANNED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PlannedStartTime").getter(OpsItem.getter(OpsItem::plannedStartTime)).setter(OpsItem.setter(Builder::plannedStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlannedStartTime").build()}).build();
    private static final SdkField<Instant> PLANNED_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PlannedEndTime").getter(OpsItem.getter(OpsItem::plannedEndTime)).setter(OpsItem.setter(Builder::plannedEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlannedEndTime").build()}).build();
    private static final SdkField<String> OPS_ITEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemArn").getter(OpsItem.getter(OpsItem::opsItemArn)).setter(OpsItem.setter(Builder::opsItemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD, OPS_ITEM_TYPE_FIELD, CREATED_TIME_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, NOTIFICATIONS_FIELD, PRIORITY_FIELD, RELATED_OPS_ITEMS_FIELD, STATUS_FIELD, OPS_ITEM_ID_FIELD, VERSION_FIELD, TITLE_FIELD, SOURCE_FIELD, OPERATIONAL_DATA_FIELD, CATEGORY_FIELD, SEVERITY_FIELD, ACTUAL_START_TIME_FIELD, ACTUAL_END_TIME_FIELD, PLANNED_START_TIME_FIELD, PLANNED_END_TIME_FIELD, OPS_ITEM_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpsItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String createdBy;
    private final String opsItemType;
    private final Instant createdTime;
    private final String description;
    private final String lastModifiedBy;
    private final Instant lastModifiedTime;
    private final List<OpsItemNotification> notifications;
    private final Integer priority;
    private final List<RelatedOpsItem> relatedOpsItems;
    private final String status;
    private final String opsItemId;
    private final String version;
    private final String title;
    private final String source;
    private final Map<String, OpsItemDataValue> operationalData;
    private final String category;
    private final String severity;
    private final Instant actualStartTime;
    private final Instant actualEndTime;
    private final Instant plannedStartTime;
    private final Instant plannedEndTime;
    private final String opsItemArn;

    private OpsItem(BuilderImpl builder) {
        this.createdBy = builder.createdBy;
        this.opsItemType = builder.opsItemType;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.notifications = builder.notifications;
        this.priority = builder.priority;
        this.relatedOpsItems = builder.relatedOpsItems;
        this.status = builder.status;
        this.opsItemId = builder.opsItemId;
        this.version = builder.version;
        this.title = builder.title;
        this.source = builder.source;
        this.operationalData = builder.operationalData;
        this.category = builder.category;
        this.severity = builder.severity;
        this.actualStartTime = builder.actualStartTime;
        this.actualEndTime = builder.actualEndTime;
        this.plannedStartTime = builder.plannedStartTime;
        this.plannedEndTime = builder.plannedEndTime;
        this.opsItemArn = builder.opsItemArn;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String opsItemType() {
        return this.opsItemType;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String description() {
        return this.description;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasNotifications() {
        return this.notifications != null && !(this.notifications instanceof SdkAutoConstructList);
    }

    public final List<OpsItemNotification> notifications() {
        return this.notifications;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final boolean hasRelatedOpsItems() {
        return this.relatedOpsItems != null && !(this.relatedOpsItems instanceof SdkAutoConstructList);
    }

    public final List<RelatedOpsItem> relatedOpsItems() {
        return this.relatedOpsItems;
    }

    public final OpsItemStatus status() {
        return OpsItemStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String opsItemId() {
        return this.opsItemId;
    }

    public final String version() {
        return this.version;
    }

    public final String title() {
        return this.title;
    }

    public final String source() {
        return this.source;
    }

    public final boolean hasOperationalData() {
        return this.operationalData != null && !(this.operationalData instanceof SdkAutoConstructMap);
    }

    public final Map<String, OpsItemDataValue> operationalData() {
        return this.operationalData;
    }

    public final String category() {
        return this.category;
    }

    public final String severity() {
        return this.severity;
    }

    public final Instant actualStartTime() {
        return this.actualStartTime;
    }

    public final Instant actualEndTime() {
        return this.actualEndTime;
    }

    public final Instant plannedStartTime() {
        return this.plannedStartTime;
    }

    public final Instant plannedEndTime() {
        return this.plannedEndTime;
    }

    public final String opsItemArn() {
        return this.opsItemArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemType());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotifications() ? this.notifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedOpsItems() ? this.relatedOpsItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationalData() ? this.operationalData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.plannedStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.plannedEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsItem)) {
            return false;
        }
        OpsItem other = (OpsItem)obj;
        return Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.opsItemType(), other.opsItemType()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasNotifications() == other.hasNotifications() && Objects.equals(this.notifications(), other.notifications()) && Objects.equals(this.priority(), other.priority()) && this.hasRelatedOpsItems() == other.hasRelatedOpsItems() && Objects.equals(this.relatedOpsItems(), other.relatedOpsItems()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.opsItemId(), other.opsItemId()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.source(), other.source()) && this.hasOperationalData() == other.hasOperationalData() && Objects.equals(this.operationalData(), other.operationalData()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.actualStartTime(), other.actualStartTime()) && Objects.equals(this.actualEndTime(), other.actualEndTime()) && Objects.equals(this.plannedStartTime(), other.plannedStartTime()) && Objects.equals(this.plannedEndTime(), other.plannedEndTime()) && Objects.equals(this.opsItemArn(), other.opsItemArn());
    }

    public final String toString() {
        return ToString.builder((String)"OpsItem").add("CreatedBy", (Object)this.createdBy()).add("OpsItemType", (Object)this.opsItemType()).add("CreatedTime", (Object)this.createdTime()).add("Description", (Object)this.description()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Notifications", this.hasNotifications() ? this.notifications() : null).add("Priority", (Object)this.priority()).add("RelatedOpsItems", this.hasRelatedOpsItems() ? this.relatedOpsItems() : null).add("Status", (Object)this.statusAsString()).add("OpsItemId", (Object)this.opsItemId()).add("Version", (Object)this.version()).add("Title", (Object)this.title()).add("Source", (Object)this.source()).add("OperationalData", this.hasOperationalData() ? this.operationalData() : null).add("Category", (Object)this.category()).add("Severity", (Object)this.severity()).add("ActualStartTime", (Object)this.actualStartTime()).add("ActualEndTime", (Object)this.actualEndTime()).add("PlannedStartTime", (Object)this.plannedStartTime()).add("PlannedEndTime", (Object)this.plannedEndTime()).add("OpsItemArn", (Object)this.opsItemArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "OpsItemType": {
                return Optional.ofNullable(clazz.cast(this.opsItemType()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Notifications": {
                return Optional.ofNullable(clazz.cast(this.notifications()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "RelatedOpsItems": {
                return Optional.ofNullable(clazz.cast(this.relatedOpsItems()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "OpsItemId": {
                return Optional.ofNullable(clazz.cast(this.opsItemId()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "OperationalData": {
                return Optional.ofNullable(clazz.cast(this.operationalData()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "ActualStartTime": {
                return Optional.ofNullable(clazz.cast(this.actualStartTime()));
            }
            case "ActualEndTime": {
                return Optional.ofNullable(clazz.cast(this.actualEndTime()));
            }
            case "PlannedStartTime": {
                return Optional.ofNullable(clazz.cast(this.plannedStartTime()));
            }
            case "PlannedEndTime": {
                return Optional.ofNullable(clazz.cast(this.plannedEndTime()));
            }
            case "OpsItemArn": {
                return Optional.ofNullable(clazz.cast(this.opsItemArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("OpsItemType", OPS_ITEM_TYPE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Notifications", NOTIFICATIONS_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("RelatedOpsItems", RELATED_OPS_ITEMS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("OpsItemId", OPS_ITEM_ID_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("OperationalData", OPERATIONAL_DATA_FIELD);
        map.put("Category", CATEGORY_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("ActualStartTime", ACTUAL_START_TIME_FIELD);
        map.put("ActualEndTime", ACTUAL_END_TIME_FIELD);
        map.put("PlannedStartTime", PLANNED_START_TIME_FIELD);
        map.put("PlannedEndTime", PLANNED_END_TIME_FIELD);
        map.put("OpsItemArn", OPS_ITEM_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpsItem, T> g) {
        return obj -> g.apply((OpsItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String createdBy;
        private String opsItemType;
        private Instant createdTime;
        private String description;
        private String lastModifiedBy;
        private Instant lastModifiedTime;
        private List<OpsItemNotification> notifications = DefaultSdkAutoConstructList.getInstance();
        private Integer priority;
        private List<RelatedOpsItem> relatedOpsItems = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String opsItemId;
        private String version;
        private String title;
        private String source;
        private Map<String, OpsItemDataValue> operationalData = DefaultSdkAutoConstructMap.getInstance();
        private String category;
        private String severity;
        private Instant actualStartTime;
        private Instant actualEndTime;
        private Instant plannedStartTime;
        private Instant plannedEndTime;
        private String opsItemArn;

        private BuilderImpl() {
        }

        private BuilderImpl(OpsItem model) {
            this.createdBy(model.createdBy);
            this.opsItemType(model.opsItemType);
            this.createdTime(model.createdTime);
            this.description(model.description);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.notifications(model.notifications);
            this.priority(model.priority);
            this.relatedOpsItems(model.relatedOpsItems);
            this.status(model.status);
            this.opsItemId(model.opsItemId);
            this.version(model.version);
            this.title(model.title);
            this.source(model.source);
            this.operationalData(model.operationalData);
            this.category(model.category);
            this.severity(model.severity);
            this.actualStartTime(model.actualStartTime);
            this.actualEndTime(model.actualEndTime);
            this.plannedStartTime(model.plannedStartTime);
            this.plannedEndTime(model.plannedEndTime);
            this.opsItemArn(model.opsItemArn);
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getOpsItemType() {
            return this.opsItemType;
        }

        public final void setOpsItemType(String opsItemType) {
            this.opsItemType = opsItemType;
        }

        @Override
        public final Builder opsItemType(String opsItemType) {
            this.opsItemType = opsItemType;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final List<OpsItemNotification.Builder> getNotifications() {
            List<OpsItemNotification.Builder> result = OpsItemNotificationsCopier.copyToBuilder(this.notifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotifications(Collection<OpsItemNotification.BuilderImpl> notifications) {
            this.notifications = OpsItemNotificationsCopier.copyFromBuilder(notifications);
        }

        @Override
        public final Builder notifications(Collection<OpsItemNotification> notifications) {
            this.notifications = OpsItemNotificationsCopier.copy(notifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(OpsItemNotification ... notifications) {
            this.notifications(Arrays.asList(notifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Consumer<OpsItemNotification.Builder> ... notifications) {
            this.notifications(Stream.of(notifications).map(c -> (OpsItemNotification)((OpsItemNotification.Builder)OpsItemNotification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final List<RelatedOpsItem.Builder> getRelatedOpsItems() {
            List<RelatedOpsItem.Builder> result = RelatedOpsItemsCopier.copyToBuilder(this.relatedOpsItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedOpsItems(Collection<RelatedOpsItem.BuilderImpl> relatedOpsItems) {
            this.relatedOpsItems = RelatedOpsItemsCopier.copyFromBuilder(relatedOpsItems);
        }

        @Override
        public final Builder relatedOpsItems(Collection<RelatedOpsItem> relatedOpsItems) {
            this.relatedOpsItems = RelatedOpsItemsCopier.copy(relatedOpsItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedOpsItems(RelatedOpsItem ... relatedOpsItems) {
            this.relatedOpsItems(Arrays.asList(relatedOpsItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedOpsItems(Consumer<RelatedOpsItem.Builder> ... relatedOpsItems) {
            this.relatedOpsItems(Stream.of(relatedOpsItems).map(c -> (RelatedOpsItem)((RelatedOpsItem.Builder)RelatedOpsItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OpsItemStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOpsItemId() {
            return this.opsItemId;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Map<String, OpsItemDataValue.Builder> getOperationalData() {
            Map<String, OpsItemDataValue.Builder> result = OpsItemOperationalDataCopier.copyToBuilder(this.operationalData);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOperationalData(Map<String, OpsItemDataValue.BuilderImpl> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copyFromBuilder(operationalData);
        }

        @Override
        public final Builder operationalData(Map<String, OpsItemDataValue> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copy(operationalData);
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final Instant getActualStartTime() {
            return this.actualStartTime;
        }

        public final void setActualStartTime(Instant actualStartTime) {
            this.actualStartTime = actualStartTime;
        }

        @Override
        public final Builder actualStartTime(Instant actualStartTime) {
            this.actualStartTime = actualStartTime;
            return this;
        }

        public final Instant getActualEndTime() {
            return this.actualEndTime;
        }

        public final void setActualEndTime(Instant actualEndTime) {
            this.actualEndTime = actualEndTime;
        }

        @Override
        public final Builder actualEndTime(Instant actualEndTime) {
            this.actualEndTime = actualEndTime;
            return this;
        }

        public final Instant getPlannedStartTime() {
            return this.plannedStartTime;
        }

        public final void setPlannedStartTime(Instant plannedStartTime) {
            this.plannedStartTime = plannedStartTime;
        }

        @Override
        public final Builder plannedStartTime(Instant plannedStartTime) {
            this.plannedStartTime = plannedStartTime;
            return this;
        }

        public final Instant getPlannedEndTime() {
            return this.plannedEndTime;
        }

        public final void setPlannedEndTime(Instant plannedEndTime) {
            this.plannedEndTime = plannedEndTime;
        }

        @Override
        public final Builder plannedEndTime(Instant plannedEndTime) {
            this.plannedEndTime = plannedEndTime;
            return this;
        }

        public final String getOpsItemArn() {
            return this.opsItemArn;
        }

        public final void setOpsItemArn(String opsItemArn) {
            this.opsItemArn = opsItemArn;
        }

        @Override
        public final Builder opsItemArn(String opsItemArn) {
            this.opsItemArn = opsItemArn;
            return this;
        }

        public OpsItem build() {
            return new OpsItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpsItem> {
        public Builder createdBy(String var1);

        public Builder opsItemType(String var1);

        public Builder createdTime(Instant var1);

        public Builder description(String var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder notifications(Collection<OpsItemNotification> var1);

        public Builder notifications(OpsItemNotification ... var1);

        public Builder notifications(Consumer<OpsItemNotification.Builder> ... var1);

        public Builder priority(Integer var1);

        public Builder relatedOpsItems(Collection<RelatedOpsItem> var1);

        public Builder relatedOpsItems(RelatedOpsItem ... var1);

        public Builder relatedOpsItems(Consumer<RelatedOpsItem.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(OpsItemStatus var1);

        public Builder opsItemId(String var1);

        public Builder version(String var1);

        public Builder title(String var1);

        public Builder source(String var1);

        public Builder operationalData(Map<String, OpsItemDataValue> var1);

        public Builder category(String var1);

        public Builder severity(String var1);

        public Builder actualStartTime(Instant var1);

        public Builder actualEndTime(Instant var1);

        public Builder plannedStartTime(Instant var1);

        public Builder plannedEndTime(Instant var1);

        public Builder opsItemArn(String var1);
    }
}

