/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.ListNodesSummaryRequest;
import software.amazon.awssdk.services.ssm.model.ListNodesSummaryResponse;

public class ListNodesSummaryIterable
implements SdkIterable<ListNodesSummaryResponse> {
    private final SsmClient client;
    private final ListNodesSummaryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNodesSummaryIterable(SsmClient client, ListNodesSummaryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNodesSummaryResponseFetcher();
    }

    public Iterator<ListNodesSummaryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Map<String, String>> summary() {
        Function<ListNodesSummaryResponse, Iterator> getIterator = response -> {
            if (response != null && response.summary() != null) {
                return response.summary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNodesSummaryResponseFetcher
    implements SyncPageFetcher<ListNodesSummaryResponse> {
        private ListNodesSummaryResponseFetcher() {
        }

        public boolean hasNextPage(ListNodesSummaryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNodesSummaryResponse nextPage(ListNodesSummaryResponse previousPage) {
            if (previousPage == null) {
                return ListNodesSummaryIterable.this.client.listNodesSummary(ListNodesSummaryIterable.this.firstRequest);
            }
            return ListNodesSummaryIterable.this.client.listNodesSummary((ListNodesSummaryRequest)((Object)ListNodesSummaryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

