/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.CalendarState;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCalendarStateResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetCalendarStateResponse> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(GetCalendarStateResponse.getter(GetCalendarStateResponse::stateAsString)).setter(GetCalendarStateResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> AT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AtTime").getter(GetCalendarStateResponse.getter(GetCalendarStateResponse::atTime)).setter(GetCalendarStateResponse.setter(Builder::atTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtTime").build()}).build();
    private static final SdkField<String> NEXT_TRANSITION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextTransitionTime").getter(GetCalendarStateResponse.getter(GetCalendarStateResponse::nextTransitionTime)).setter(GetCalendarStateResponse.setter(Builder::nextTransitionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextTransitionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, AT_TIME_FIELD, NEXT_TRANSITION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCalendarStateResponse.memberNameToFieldInitializer();
    private final String state;
    private final String atTime;
    private final String nextTransitionTime;

    private GetCalendarStateResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.atTime = builder.atTime;
        this.nextTransitionTime = builder.nextTransitionTime;
    }

    public final CalendarState state() {
        return CalendarState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String atTime() {
        return this.atTime;
    }

    public final String nextTransitionTime() {
        return this.nextTransitionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.atTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextTransitionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCalendarStateResponse)) {
            return false;
        }
        GetCalendarStateResponse other = (GetCalendarStateResponse)((Object)obj);
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.atTime(), other.atTime()) && Objects.equals(this.nextTransitionTime(), other.nextTransitionTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetCalendarStateResponse").add("State", (Object)this.stateAsString()).add("AtTime", (Object)this.atTime()).add("NextTransitionTime", (Object)this.nextTransitionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "AtTime": {
                return Optional.ofNullable(clazz.cast(this.atTime()));
            }
            case "NextTransitionTime": {
                return Optional.ofNullable(clazz.cast(this.nextTransitionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("State", STATE_FIELD);
        map.put("AtTime", AT_TIME_FIELD);
        map.put("NextTransitionTime", NEXT_TRANSITION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCalendarStateResponse, T> g) {
        return obj -> g.apply((GetCalendarStateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String state;
        private String atTime;
        private String nextTransitionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCalendarStateResponse model) {
            super(model);
            this.state(model.state);
            this.atTime(model.atTime);
            this.nextTransitionTime(model.nextTransitionTime);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CalendarState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getAtTime() {
            return this.atTime;
        }

        public final void setAtTime(String atTime) {
            this.atTime = atTime;
        }

        @Override
        public final Builder atTime(String atTime) {
            this.atTime = atTime;
            return this;
        }

        public final String getNextTransitionTime() {
            return this.nextTransitionTime;
        }

        public final void setNextTransitionTime(String nextTransitionTime) {
            this.nextTransitionTime = nextTransitionTime;
        }

        @Override
        public final Builder nextTransitionTime(String nextTransitionTime) {
            this.nextTransitionTime = nextTransitionTime;
            return this;
        }

        @Override
        public GetCalendarStateResponse build() {
            return new GetCalendarStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCalendarStateResponse> {
        public Builder state(String var1);

        public Builder state(CalendarState var1);

        public Builder atTime(String var1);

        public Builder nextTransitionTime(String var1);
    }
}

