/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class MaintenanceWindowTaskParametersListCopier {
    static List<Map<String, MaintenanceWindowTaskParameterValueExpression>> copy(
            Collection<? extends Map<String, ? extends MaintenanceWindowTaskParameterValueExpression>> maintenanceWindowTaskParametersListParam) {
        List<Map<String, MaintenanceWindowTaskParameterValueExpression>> list;
        if (maintenanceWindowTaskParametersListParam == null
                || maintenanceWindowTaskParametersListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, MaintenanceWindowTaskParameterValueExpression>> modifiableList = new ArrayList<>(
                    maintenanceWindowTaskParametersListParam.size());
            maintenanceWindowTaskParametersListParam.forEach(entry -> {
                Map<String, MaintenanceWindowTaskParameterValueExpression> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, MaintenanceWindowTaskParameterValueExpression> modifiableMap = new LinkedHashMap<>(entry.size());
                    entry.forEach((key, value) -> {
                        modifiableMap.put(key, value);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Map<String, MaintenanceWindowTaskParameterValueExpression>> copyFromBuilder(
            Collection<? extends Map<String, ? extends MaintenanceWindowTaskParameterValueExpression.Builder>> maintenanceWindowTaskParametersListParam) {
        List<Map<String, MaintenanceWindowTaskParameterValueExpression>> list;
        if (maintenanceWindowTaskParametersListParam == null
                || maintenanceWindowTaskParametersListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, MaintenanceWindowTaskParameterValueExpression>> modifiableList = new ArrayList<>(
                    maintenanceWindowTaskParametersListParam.size());
            maintenanceWindowTaskParametersListParam.forEach(entry -> {
                Map<String, MaintenanceWindowTaskParameterValueExpression> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, MaintenanceWindowTaskParameterValueExpression> modifiableMap = new LinkedHashMap<>(entry.size());
                    entry.forEach((key, value) -> {
                        MaintenanceWindowTaskParameterValueExpression member = value == null ? null : value.build();
                        modifiableMap.put(key, member);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Map<String, MaintenanceWindowTaskParameterValueExpression.Builder>> copyToBuilder(
            Collection<? extends Map<String, ? extends MaintenanceWindowTaskParameterValueExpression>> maintenanceWindowTaskParametersListParam) {
        List<Map<String, MaintenanceWindowTaskParameterValueExpression.Builder>> list;
        if (maintenanceWindowTaskParametersListParam == null
                || maintenanceWindowTaskParametersListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, MaintenanceWindowTaskParameterValueExpression.Builder>> modifiableList = new ArrayList<>(
                    maintenanceWindowTaskParametersListParam.size());
            maintenanceWindowTaskParametersListParam.forEach(entry -> {
                Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> modifiableMap = new LinkedHashMap<>(entry
                            .size());
                    entry.forEach((key, value) -> {
                        MaintenanceWindowTaskParameterValueExpression.Builder member = value == null ? null : value.toBuilder();
                        modifiableMap.put(key, member);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
