/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Either a count, remaining count, or a version number in a delete inventory summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InventoryDeletionSummaryItem implements SdkPojo, Serializable,
        ToCopyableBuilder<InventoryDeletionSummaryItem.Builder, InventoryDeletionSummaryItem> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(InventoryDeletionSummaryItem::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(InventoryDeletionSummaryItem::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<Integer> REMAINING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RemainingCount").getter(getter(InventoryDeletionSummaryItem::remainingCount))
            .setter(setter(Builder::remainingCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemainingCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, COUNT_FIELD,
            REMAINING_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String version;

    private final Integer count;

    private final Integer remainingCount;

    private InventoryDeletionSummaryItem(BuilderImpl builder) {
        this.version = builder.version;
        this.count = builder.count;
        this.remainingCount = builder.remainingCount;
    }

    /**
     * <p>
     * The inventory type version.
     * </p>
     * 
     * @return The inventory type version.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * A count of the number of deleted items.
     * </p>
     * 
     * @return A count of the number of deleted items.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The remaining number of items to delete.
     * </p>
     * 
     * @return The remaining number of items to delete.
     */
    public final Integer remainingCount() {
        return remainingCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(remainingCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryDeletionSummaryItem)) {
            return false;
        }
        InventoryDeletionSummaryItem other = (InventoryDeletionSummaryItem) obj;
        return Objects.equals(version(), other.version()) && Objects.equals(count(), other.count())
                && Objects.equals(remainingCount(), other.remainingCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InventoryDeletionSummaryItem").add("Version", version()).add("Count", count())
                .add("RemainingCount", remainingCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "RemainingCount":
            return Optional.ofNullable(clazz.cast(remainingCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Version", VERSION_FIELD);
        map.put("Count", COUNT_FIELD);
        map.put("RemainingCount", REMAINING_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InventoryDeletionSummaryItem, T> g) {
        return obj -> g.apply((InventoryDeletionSummaryItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InventoryDeletionSummaryItem> {
        /**
         * <p>
         * The inventory type version.
         * </p>
         * 
         * @param version
         *        The inventory type version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * A count of the number of deleted items.
         * </p>
         * 
         * @param count
         *        A count of the number of deleted items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The remaining number of items to delete.
         * </p>
         * 
         * @param remainingCount
         *        The remaining number of items to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remainingCount(Integer remainingCount);
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private Integer count;

        private Integer remainingCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryDeletionSummaryItem model) {
            version(model.version);
            count(model.count);
            remainingCount(model.remainingCount);
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Integer getRemainingCount() {
            return remainingCount;
        }

        public final void setRemainingCount(Integer remainingCount) {
            this.remainingCount = remainingCount;
        }

        @Override
        public final Builder remainingCount(Integer remainingCount) {
            this.remainingCount = remainingCount;
            return this;
        }

        @Override
        public InventoryDeletionSummaryItem build() {
            return new InventoryDeletionSummaryItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
