/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more aggregators for viewing counts of nodes using different dimensions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeAggregator implements SdkPojo, Serializable, ToCopyableBuilder<NodeAggregator.Builder, NodeAggregator> {
    private static final SdkField<String> AGGREGATOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggregatorType").getter(getter(NodeAggregator::aggregatorTypeAsString))
            .setter(setter(Builder::aggregatorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorType").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(NodeAggregator::typeNameAsString)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(NodeAggregator::attributeNameAsString))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<List<NodeAggregator>> AGGREGATORS_FIELD = SdkField
            .<List<NodeAggregator>> builder(MarshallingType.LIST)
            .memberName("Aggregators")
            .getter(getter(NodeAggregator::aggregators))
            .setter(setter(Builder::aggregators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeAggregator> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeAggregator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATOR_TYPE_FIELD,
            TYPE_NAME_FIELD, ATTRIBUTE_NAME_FIELD, AGGREGATORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String aggregatorType;

    private final String typeName;

    private final String attributeName;

    private final List<NodeAggregator> aggregators;

    private NodeAggregator(BuilderImpl builder) {
        this.aggregatorType = builder.aggregatorType;
        this.typeName = builder.typeName;
        this.attributeName = builder.attributeName;
        this.aggregators = builder.aggregators;
    }

    /**
     * <p>
     * The aggregator type for limiting a node summary. Currently, only <code>Count</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregatorType}
     * will return {@link NodeAggregatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregatorTypeAsString}.
     * </p>
     * 
     * @return The aggregator type for limiting a node summary. Currently, only <code>Count</code> is supported.
     * @see NodeAggregatorType
     */
    public final NodeAggregatorType aggregatorType() {
        return NodeAggregatorType.fromValue(aggregatorType);
    }

    /**
     * <p>
     * The aggregator type for limiting a node summary. Currently, only <code>Count</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregatorType}
     * will return {@link NodeAggregatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregatorTypeAsString}.
     * </p>
     * 
     * @return The aggregator type for limiting a node summary. Currently, only <code>Count</code> is supported.
     * @see NodeAggregatorType
     */
    public final String aggregatorTypeAsString() {
        return aggregatorType;
    }

    /**
     * <p>
     * The data type name to use for viewing counts of nodes. Currently, only <code>Instance</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeName} will
     * return {@link NodeTypeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeNameAsString}.
     * </p>
     * 
     * @return The data type name to use for viewing counts of nodes. Currently, only <code>Instance</code> is
     *         supported.
     * @see NodeTypeName
     */
    public final NodeTypeName typeName() {
        return NodeTypeName.fromValue(typeName);
    }

    /**
     * <p>
     * The data type name to use for viewing counts of nodes. Currently, only <code>Instance</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeName} will
     * return {@link NodeTypeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeNameAsString}.
     * </p>
     * 
     * @return The data type name to use for viewing counts of nodes. Currently, only <code>Instance</code> is
     *         supported.
     * @see NodeTypeName
     */
    public final String typeNameAsString() {
        return typeName;
    }

    /**
     * <p>
     * The name of a node attribute on which to limit the count of nodes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeName}
     * will return {@link NodeAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeNameAsString}.
     * </p>
     * 
     * @return The name of a node attribute on which to limit the count of nodes.
     * @see NodeAttributeName
     */
    public final NodeAttributeName attributeName() {
        return NodeAttributeName.fromValue(attributeName);
    }

    /**
     * <p>
     * The name of a node attribute on which to limit the count of nodes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeName}
     * will return {@link NodeAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeNameAsString}.
     * </p>
     * 
     * @return The name of a node attribute on which to limit the count of nodes.
     * @see NodeAttributeName
     */
    public final String attributeNameAsString() {
        return attributeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aggregators property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregators() {
        return aggregators != null && !(aggregators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about aggregators used to refine a node summary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregators} method.
     * </p>
     * 
     * @return Information about aggregators used to refine a node summary.
     */
    public final List<NodeAggregator> aggregators() {
        return aggregators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregatorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregators() ? aggregators() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeAggregator)) {
            return false;
        }
        NodeAggregator other = (NodeAggregator) obj;
        return Objects.equals(aggregatorTypeAsString(), other.aggregatorTypeAsString())
                && Objects.equals(typeNameAsString(), other.typeNameAsString())
                && Objects.equals(attributeNameAsString(), other.attributeNameAsString())
                && hasAggregators() == other.hasAggregators() && Objects.equals(aggregators(), other.aggregators());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeAggregator").add("AggregatorType", aggregatorTypeAsString())
                .add("TypeName", typeNameAsString()).add("AttributeName", attributeNameAsString())
                .add("Aggregators", hasAggregators() ? aggregators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregatorType":
            return Optional.ofNullable(clazz.cast(aggregatorTypeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeNameAsString()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeNameAsString()));
        case "Aggregators":
            return Optional.ofNullable(clazz.cast(aggregators()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AggregatorType", AGGREGATOR_TYPE_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("Aggregators", AGGREGATORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeAggregator, T> g) {
        return obj -> g.apply((NodeAggregator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeAggregator> {
        /**
         * <p>
         * The aggregator type for limiting a node summary. Currently, only <code>Count</code> is supported.
         * </p>
         * 
         * @param aggregatorType
         *        The aggregator type for limiting a node summary. Currently, only <code>Count</code> is supported.
         * @see NodeAggregatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeAggregatorType
         */
        Builder aggregatorType(String aggregatorType);

        /**
         * <p>
         * The aggregator type for limiting a node summary. Currently, only <code>Count</code> is supported.
         * </p>
         * 
         * @param aggregatorType
         *        The aggregator type for limiting a node summary. Currently, only <code>Count</code> is supported.
         * @see NodeAggregatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeAggregatorType
         */
        Builder aggregatorType(NodeAggregatorType aggregatorType);

        /**
         * <p>
         * The data type name to use for viewing counts of nodes. Currently, only <code>Instance</code> is supported.
         * </p>
         * 
         * @param typeName
         *        The data type name to use for viewing counts of nodes. Currently, only <code>Instance</code> is
         *        supported.
         * @see NodeTypeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeTypeName
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The data type name to use for viewing counts of nodes. Currently, only <code>Instance</code> is supported.
         * </p>
         * 
         * @param typeName
         *        The data type name to use for viewing counts of nodes. Currently, only <code>Instance</code> is
         *        supported.
         * @see NodeTypeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeTypeName
         */
        Builder typeName(NodeTypeName typeName);

        /**
         * <p>
         * The name of a node attribute on which to limit the count of nodes.
         * </p>
         * 
         * @param attributeName
         *        The name of a node attribute on which to limit the count of nodes.
         * @see NodeAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeAttributeName
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The name of a node attribute on which to limit the count of nodes.
         * </p>
         * 
         * @param attributeName
         *        The name of a node attribute on which to limit the count of nodes.
         * @see NodeAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeAttributeName
         */
        Builder attributeName(NodeAttributeName attributeName);

        /**
         * <p>
         * Information about aggregators used to refine a node summary.
         * </p>
         * 
         * @param aggregators
         *        Information about aggregators used to refine a node summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(Collection<NodeAggregator> aggregators);

        /**
         * <p>
         * Information about aggregators used to refine a node summary.
         * </p>
         * 
         * @param aggregators
         *        Information about aggregators used to refine a node summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(NodeAggregator... aggregators);

        /**
         * <p>
         * Information about aggregators used to refine a node summary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.NodeAggregator.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssm.model.NodeAggregator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.NodeAggregator.Builder#build()} is called immediately and
         * its result is passed to {@link #aggregators(List<NodeAggregator>)}.
         * 
         * @param aggregators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.NodeAggregator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregators(java.util.Collection<NodeAggregator>)
         */
        Builder aggregators(Consumer<Builder>... aggregators);
    }

    static final class BuilderImpl implements Builder {
        private String aggregatorType;

        private String typeName;

        private String attributeName;

        private List<NodeAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeAggregator model) {
            aggregatorType(model.aggregatorType);
            typeName(model.typeName);
            attributeName(model.attributeName);
            aggregators(model.aggregators);
        }

        public final String getAggregatorType() {
            return aggregatorType;
        }

        public final void setAggregatorType(String aggregatorType) {
            this.aggregatorType = aggregatorType;
        }

        @Override
        public final Builder aggregatorType(String aggregatorType) {
            this.aggregatorType = aggregatorType;
            return this;
        }

        @Override
        public final Builder aggregatorType(NodeAggregatorType aggregatorType) {
            this.aggregatorType(aggregatorType == null ? null : aggregatorType.toString());
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @Override
        public final Builder typeName(NodeTypeName typeName) {
            this.typeName(typeName == null ? null : typeName.toString());
            return this;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        @Override
        public final Builder attributeName(NodeAttributeName attributeName) {
            this.attributeName(attributeName == null ? null : attributeName.toString());
            return this;
        }

        public final List<Builder> getAggregators() {
            List<Builder> result = NodeAggregatorListCopier.copyToBuilder(this.aggregators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregators(Collection<BuilderImpl> aggregators) {
            this.aggregators = NodeAggregatorListCopier.copyFromBuilder(aggregators);
        }

        @Override
        public final Builder aggregators(Collection<NodeAggregator> aggregators) {
            this.aggregators = NodeAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(NodeAggregator... aggregators) {
            aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(Consumer<Builder>... aggregators) {
            aggregators(Stream.of(aggregators).map(c -> NodeAggregator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public NodeAggregator build() {
            return new NodeAggregator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
