/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum AutomationExecutionFilterKey {
    DOCUMENT_NAME_PREFIX("DocumentNamePrefix"),

    EXECUTION_STATUS("ExecutionStatus"),

    EXECUTION_ID("ExecutionId"),

    PARENT_EXECUTION_ID("ParentExecutionId"),

    CURRENT_ACTION("CurrentAction"),

    START_TIME_BEFORE("StartTimeBefore"),

    START_TIME_AFTER("StartTimeAfter"),

    AUTOMATION_TYPE("AutomationType"),

    TAG_KEY("TagKey"),

    TARGET_RESOURCE_GROUP("TargetResourceGroup"),

    AUTOMATION_SUBTYPE("AutomationSubtype"),

    OPS_ITEM_ID("OpsItemId"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutomationExecutionFilterKey> VALUE_MAP = EnumUtils.uniqueIndex(
            AutomationExecutionFilterKey.class, AutomationExecutionFilterKey::toString);

    private final String value;

    private AutomationExecutionFilterKey(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AutomationExecutionFilterKey corresponding to the value
     */
    public static AutomationExecutionFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AutomationExecutionFilterKey}s
     */
    public static Set<AutomationExecutionFilterKey> knownValues() {
        Set<AutomationExecutionFilterKey> knownValues = EnumSet.allOf(AutomationExecutionFilterKey.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
