/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.DescribeParametersRequest;
import software.amazon.awssdk.services.ssm.model.DescribeParametersResponse;

public class DescribeParametersIterable
implements SdkIterable<DescribeParametersResponse> {
    private final SsmClient client;
    private final DescribeParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeParametersIterable(SsmClient client, DescribeParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeParametersResponseFetcher();
    }

    public Iterator<DescribeParametersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeParametersIterable resume(DescribeParametersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeParametersIterable(this.client, (DescribeParametersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeParametersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeParametersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeParametersResponseFetcher
    implements SyncPageFetcher<DescribeParametersResponse> {
        private DescribeParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeParametersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeParametersResponse nextPage(DescribeParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeParametersIterable.this.client.describeParameters(DescribeParametersIterable.this.firstRequest);
            }
            return DescribeParametersIterable.this.client.describeParameters((DescribeParametersRequest)((Object)DescribeParametersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

