/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeployablePatchSnapshotForInstanceRequest extends SsmRequest implements
        ToCopyableBuilder<GetDeployablePatchSnapshotForInstanceRequest.Builder, GetDeployablePatchSnapshotForInstanceRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDeployablePatchSnapshotForInstanceRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDeployablePatchSnapshotForInstanceRequest::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            SNAPSHOT_ID_FIELD));

    private final String instanceId;

    private final String snapshotId;

    private GetDeployablePatchSnapshotForInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * The ID of the instance for which the appropriate patch snapshot should be retrieved.
     * </p>
     * 
     * @return The ID of the instance for which the appropriate patch snapshot should be retrieved.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The user-defined snapshot ID.
     * </p>
     * 
     * @return The user-defined snapshot ID.
     */
    public String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeployablePatchSnapshotForInstanceRequest)) {
            return false;
        }
        GetDeployablePatchSnapshotForInstanceRequest other = (GetDeployablePatchSnapshotForInstanceRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(snapshotId(), other.snapshotId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDeployablePatchSnapshotForInstanceRequest").add("InstanceId", instanceId())
                .add("SnapshotId", snapshotId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeployablePatchSnapshotForInstanceRequest, T> g) {
        return obj -> g.apply((GetDeployablePatchSnapshotForInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceRequest> {
        /**
         * <p>
         * The ID of the instance for which the appropriate patch snapshot should be retrieved.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance for which the appropriate patch snapshot should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The user-defined snapshot ID.
         * </p>
         * 
         * @param snapshotId
         *        The user-defined snapshot ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeployablePatchSnapshotForInstanceRequest model) {
            super(model);
            instanceId(model.instanceId);
            snapshotId(model.snapshotId);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDeployablePatchSnapshotForInstanceRequest build() {
            return new GetDeployablePatchSnapshotForInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
