/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ComplianceItem;
import software.amazon.awssdk.services.ssm.model.ComplianceItemListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComplianceItemsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListComplianceItemsResponse> {
    private static final SdkField<List<ComplianceItem>> COMPLIANCE_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComplianceItems").getter(ListComplianceItemsResponse.getter(ListComplianceItemsResponse::complianceItems)).setter(ListComplianceItemsResponse.setter(Builder::complianceItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComplianceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListComplianceItemsResponse.getter(ListComplianceItemsResponse::nextToken)).setter(ListComplianceItemsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ComplianceItems", COMPLIANCE_ITEMS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ComplianceItem> complianceItems;
    private final String nextToken;

    private ListComplianceItemsResponse(BuilderImpl builder) {
        super(builder);
        this.complianceItems = builder.complianceItems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasComplianceItems() {
        return this.complianceItems != null && !(this.complianceItems instanceof SdkAutoConstructList);
    }

    public final List<ComplianceItem> complianceItems() {
        return this.complianceItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComplianceItems() ? this.complianceItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComplianceItemsResponse)) {
            return false;
        }
        ListComplianceItemsResponse other = (ListComplianceItemsResponse)((Object)obj);
        return this.hasComplianceItems() == other.hasComplianceItems() && Objects.equals(this.complianceItems(), other.complianceItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListComplianceItemsResponse").add("ComplianceItems", this.hasComplianceItems() ? this.complianceItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceItems": {
                return Optional.ofNullable(clazz.cast(this.complianceItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListComplianceItemsResponse, T> g) {
        return obj -> g.apply((ListComplianceItemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<ComplianceItem> complianceItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComplianceItemsResponse model) {
            super(model);
            this.complianceItems(model.complianceItems);
            this.nextToken(model.nextToken);
        }

        public final List<ComplianceItem.Builder> getComplianceItems() {
            List<ComplianceItem.Builder> result = ComplianceItemListCopier.copyToBuilder(this.complianceItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComplianceItems(Collection<ComplianceItem.BuilderImpl> complianceItems) {
            this.complianceItems = ComplianceItemListCopier.copyFromBuilder(complianceItems);
        }

        @Override
        public final Builder complianceItems(Collection<ComplianceItem> complianceItems) {
            this.complianceItems = ComplianceItemListCopier.copy(complianceItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceItems(ComplianceItem ... complianceItems) {
            this.complianceItems(Arrays.asList(complianceItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceItems(Consumer<ComplianceItem.Builder> ... complianceItems) {
            this.complianceItems(Stream.of(complianceItems).map(c -> (ComplianceItem)((ComplianceItem.Builder)ComplianceItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComplianceItemsResponse build() {
            return new ListComplianceItemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComplianceItemsResponse> {
        public Builder complianceItems(Collection<ComplianceItem> var1);

        public Builder complianceItems(ComplianceItem ... var1);

        public Builder complianceItems(Consumer<ComplianceItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

