/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetLocation;
import software.amazon.awssdk.services.ssm.model.TargetLocationsCopier;
import software.amazon.awssdk.services.ssm.model.TargetMapsCopier;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Runbook
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Runbook> {
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentName").getter(Runbook.getter(Runbook::documentName)).setter(Runbook.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(Runbook.getter(Runbook::documentVersion)).setter(Runbook.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(Runbook.getter(Runbook::parameters)).setter(Runbook.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetParameterName").getter(Runbook.getter(Runbook::targetParameterName)).setter(Runbook.setter(Builder::targetParameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameterName").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(Runbook.getter(Runbook::targets)).setter(Runbook.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetMaps").getter(Runbook.getter(Runbook::targetMaps)).setter(Runbook.setter(Builder::targetMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxConcurrency").getter(Runbook.getter(Runbook::maxConcurrency)).setter(Runbook.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxErrors").getter(Runbook.getter(Runbook::maxErrors)).setter(Runbook.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetLocations").getter(Runbook.getter(Runbook::targetLocations)).setter(Runbook.setter(Builder::targetLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, PARAMETERS_FIELD, TARGET_PARAMETER_NAME_FIELD, TARGETS_FIELD, TARGET_MAPS_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, TARGET_LOCATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DocumentName", DOCUMENT_NAME_FIELD);
            this.put("DocumentVersion", DOCUMENT_VERSION_FIELD);
            this.put("Parameters", PARAMETERS_FIELD);
            this.put("TargetParameterName", TARGET_PARAMETER_NAME_FIELD);
            this.put("Targets", TARGETS_FIELD);
            this.put("TargetMaps", TARGET_MAPS_FIELD);
            this.put("MaxConcurrency", MAX_CONCURRENCY_FIELD);
            this.put("MaxErrors", MAX_ERRORS_FIELD);
            this.put("TargetLocations", TARGET_LOCATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String documentName;
    private final String documentVersion;
    private final Map<String, List<String>> parameters;
    private final String targetParameterName;
    private final List<Target> targets;
    private final List<Map<String, List<String>>> targetMaps;
    private final String maxConcurrency;
    private final String maxErrors;
    private final List<TargetLocation> targetLocations;

    private Runbook(BuilderImpl builder) {
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.parameters = builder.parameters;
        this.targetParameterName = builder.targetParameterName;
        this.targets = builder.targets;
        this.targetMaps = builder.targetMaps;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.targetLocations = builder.targetLocations;
    }

    public final String documentName() {
        return this.documentName;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public final String targetParameterName() {
        return this.targetParameterName;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final boolean hasTargetMaps() {
        return this.targetMaps != null && !(this.targetMaps instanceof SdkAutoConstructList);
    }

    public final List<Map<String, List<String>>> targetMaps() {
        return this.targetMaps;
    }

    public final String maxConcurrency() {
        return this.maxConcurrency;
    }

    public final String maxErrors() {
        return this.maxErrors;
    }

    public final boolean hasTargetLocations() {
        return this.targetLocations != null && !(this.targetLocations instanceof SdkAutoConstructList);
    }

    public final List<TargetLocation> targetLocations() {
        return this.targetLocations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetMaps() ? this.targetMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetLocations() ? this.targetLocations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Runbook)) {
            return false;
        }
        Runbook other = (Runbook)obj;
        return Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.targetParameterName(), other.targetParameterName()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasTargetMaps() == other.hasTargetMaps() && Objects.equals(this.targetMaps(), other.targetMaps()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && this.hasTargetLocations() == other.hasTargetLocations() && Objects.equals(this.targetLocations(), other.targetLocations());
    }

    public final String toString() {
        return ToString.builder((String)"Runbook").add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("TargetParameterName", (Object)this.targetParameterName()).add("Targets", this.hasTargets() ? this.targets() : null).add("TargetMaps", this.hasTargetMaps() ? this.targetMaps() : null).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("TargetLocations", this.hasTargetLocations() ? this.targetLocations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "TargetParameterName": {
                return Optional.ofNullable(clazz.cast(this.targetParameterName()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "TargetMaps": {
                return Optional.ofNullable(clazz.cast(this.targetMaps()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "TargetLocations": {
                return Optional.ofNullable(clazz.cast(this.targetLocations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Runbook, T> g) {
        return obj -> g.apply((Runbook)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentName;
        private String documentVersion;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String targetParameterName;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();
        private String maxConcurrency;
        private String maxErrors;
        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Runbook model) {
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.parameters(model.parameters);
            this.targetParameterName(model.targetParameterName);
            this.targets(model.targets);
            this.targetMaps(model.targetMaps);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.targetLocations(model.targetLocations);
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final String getTargetParameterName() {
            return this.targetParameterName;
        }

        public final void setTargetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
        }

        @Override
        public final Builder targetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            if (this.targetMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetMaps;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>> ... targetMaps) {
            this.targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final List<TargetLocation.Builder> getTargetLocations() {
            List<TargetLocation.Builder> result = TargetLocationsCopier.copyToBuilder(this.targetLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        @Override
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(TargetLocation ... targetLocations) {
            this.targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder> ... targetLocations) {
            this.targetLocations(Stream.of(targetLocations).map(c -> (TargetLocation)((TargetLocation.Builder)TargetLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Runbook build() {
            return new Runbook(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Runbook> {
        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder targetParameterName(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> var1);

        public Builder targetMaps(Map<String, ? extends Collection<String>> ... var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder targetLocations(Collection<TargetLocation> var1);

        public Builder targetLocations(TargetLocation ... var1);

        public Builder targetLocations(Consumer<TargetLocation.Builder> ... var1);
    }
}

