/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InventoryItemEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InventoryResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InventoryResultItem> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(InventoryResultItem.getter(InventoryResultItem::typeName)).setter(InventoryResultItem.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersion").getter(InventoryResultItem.getter(InventoryResultItem::schemaVersion)).setter(InventoryResultItem.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()}).build();
    private static final SdkField<String> CAPTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaptureTime").getter(InventoryResultItem.getter(InventoryResultItem::captureTime)).setter(InventoryResultItem.setter(Builder::captureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureTime").build()}).build();
    private static final SdkField<String> CONTENT_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentHash").getter(InventoryResultItem.getter(InventoryResultItem::contentHash)).setter(InventoryResultItem.setter(Builder::contentHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentHash").build()}).build();
    private static final SdkField<List<Map<String, String>>> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Content").getter(InventoryResultItem.getter(InventoryResultItem::content)).setter(InventoryResultItem.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD, SCHEMA_VERSION_FIELD, CAPTURE_TIME_FIELD, CONTENT_HASH_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TypeName", TYPE_NAME_FIELD);
            this.put("SchemaVersion", SCHEMA_VERSION_FIELD);
            this.put("CaptureTime", CAPTURE_TIME_FIELD);
            this.put("ContentHash", CONTENT_HASH_FIELD);
            this.put("Content", CONTENT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String typeName;
    private final String schemaVersion;
    private final String captureTime;
    private final String contentHash;
    private final List<Map<String, String>> content;

    private InventoryResultItem(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.schemaVersion = builder.schemaVersion;
        this.captureTime = builder.captureTime;
        this.contentHash = builder.contentHash;
        this.content = builder.content;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String schemaVersion() {
        return this.schemaVersion;
    }

    public final String captureTime() {
        return this.captureTime;
    }

    public final String contentHash() {
        return this.contentHash;
    }

    public final boolean hasContent() {
        return this.content != null && !(this.content instanceof SdkAutoConstructList);
    }

    public final List<Map<String, String>> content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.captureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContent() ? this.content() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryResultItem)) {
            return false;
        }
        InventoryResultItem other = (InventoryResultItem)obj;
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.captureTime(), other.captureTime()) && Objects.equals(this.contentHash(), other.contentHash()) && this.hasContent() == other.hasContent() && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"InventoryResultItem").add("TypeName", (Object)this.typeName()).add("SchemaVersion", (Object)this.schemaVersion()).add("CaptureTime", (Object)this.captureTime()).add("ContentHash", (Object)this.contentHash()).add("Content", this.hasContent() ? this.content() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "SchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "CaptureTime": {
                return Optional.ofNullable(clazz.cast(this.captureTime()));
            }
            case "ContentHash": {
                return Optional.ofNullable(clazz.cast(this.contentHash()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InventoryResultItem, T> g) {
        return obj -> g.apply((InventoryResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeName;
        private String schemaVersion;
        private String captureTime;
        private String contentHash;
        private List<Map<String, String>> content = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryResultItem model) {
            this.typeName(model.typeName);
            this.schemaVersion(model.schemaVersion);
            this.captureTime(model.captureTime);
            this.contentHash(model.contentHash);
            this.content(model.content);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final String getCaptureTime() {
            return this.captureTime;
        }

        public final void setCaptureTime(String captureTime) {
            this.captureTime = captureTime;
        }

        @Override
        public final Builder captureTime(String captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final String getContentHash() {
            return this.contentHash;
        }

        public final void setContentHash(String contentHash) {
            this.contentHash = contentHash;
        }

        @Override
        public final Builder contentHash(String contentHash) {
            this.contentHash = contentHash;
            return this;
        }

        public final Collection<? extends Map<String, String>> getContent() {
            if (this.content instanceof SdkAutoConstructList) {
                return null;
            }
            return this.content;
        }

        public final void setContent(Collection<? extends Map<String, String>> content) {
            this.content = InventoryItemEntryListCopier.copy(content);
        }

        @Override
        public final Builder content(Collection<? extends Map<String, String>> content) {
            this.content = InventoryItemEntryListCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Map<String, String> ... content) {
            this.content(Arrays.asList(content));
            return this;
        }

        public InventoryResultItem build() {
            return new InventoryResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InventoryResultItem> {
        public Builder typeName(String var1);

        public Builder schemaVersion(String var1);

        public Builder captureTime(String var1);

        public Builder contentHash(String var1);

        public Builder content(Collection<? extends Map<String, String>> var1);

        public Builder content(Map<String, String> ... var1);
    }
}

