/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CommandStatus {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    SUCCESS("Success"),
    CANCELLED("Cancelled"),
    FAILED("Failed"),
    TIMED_OUT("TimedOut"),
    CANCELLING("Cancelling"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CommandStatus> VALUE_MAP;
    private final String value;

    private CommandStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommandStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommandStatus> knownValues() {
        EnumSet<CommandStatus> knownValues = EnumSet.allOf(CommandStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CommandStatus.class, CommandStatus::toString);
    }
}

