/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the result of a document review request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReviewInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ReviewInformation.Builder, ReviewInformation> {
    private static final SdkField<Instant> REVIEWED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReviewedTime").getter(getter(ReviewInformation::reviewedTime)).setter(setter(Builder::reviewedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewedTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReviewInformation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> REVIEWER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Reviewer").getter(getter(ReviewInformation::reviewer)).setter(setter(Builder::reviewer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reviewer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVIEWED_TIME_FIELD,
            STATUS_FIELD, REVIEWER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant reviewedTime;

    private final String status;

    private final String reviewer;

    private ReviewInformation(BuilderImpl builder) {
        this.reviewedTime = builder.reviewedTime;
        this.status = builder.status;
        this.reviewer = builder.reviewer;
    }

    /**
     * <p>
     * The time that the reviewer took action on the document review request.
     * </p>
     * 
     * @return The time that the reviewer took action on the document review request.
     */
    public final Instant reviewedTime() {
        return reviewedTime;
    }

    /**
     * <p>
     * The current status of the document review request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the document review request.
     * @see ReviewStatus
     */
    public final ReviewStatus status() {
        return ReviewStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the document review request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the document review request.
     * @see ReviewStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reviewer assigned to take action on the document review request.
     * </p>
     * 
     * @return The reviewer assigned to take action on the document review request.
     */
    public final String reviewer() {
        return reviewer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reviewedTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reviewer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewInformation)) {
            return false;
        }
        ReviewInformation other = (ReviewInformation) obj;
        return Objects.equals(reviewedTime(), other.reviewedTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(reviewer(), other.reviewer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReviewInformation").add("ReviewedTime", reviewedTime()).add("Status", statusAsString())
                .add("Reviewer", reviewer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReviewedTime":
            return Optional.ofNullable(clazz.cast(reviewedTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Reviewer":
            return Optional.ofNullable(clazz.cast(reviewer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReviewInformation, T> g) {
        return obj -> g.apply((ReviewInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReviewInformation> {
        /**
         * <p>
         * The time that the reviewer took action on the document review request.
         * </p>
         * 
         * @param reviewedTime
         *        The time that the reviewer took action on the document review request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewedTime(Instant reviewedTime);

        /**
         * <p>
         * The current status of the document review request.
         * </p>
         * 
         * @param status
         *        The current status of the document review request.
         * @see ReviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the document review request.
         * </p>
         * 
         * @param status
         *        The current status of the document review request.
         * @see ReviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewStatus
         */
        Builder status(ReviewStatus status);

        /**
         * <p>
         * The reviewer assigned to take action on the document review request.
         * </p>
         * 
         * @param reviewer
         *        The reviewer assigned to take action on the document review request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewer(String reviewer);
    }

    static final class BuilderImpl implements Builder {
        private Instant reviewedTime;

        private String status;

        private String reviewer;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewInformation model) {
            reviewedTime(model.reviewedTime);
            status(model.status);
            reviewer(model.reviewer);
        }

        public final Instant getReviewedTime() {
            return reviewedTime;
        }

        public final void setReviewedTime(Instant reviewedTime) {
            this.reviewedTime = reviewedTime;
        }

        @Override
        public final Builder reviewedTime(Instant reviewedTime) {
            this.reviewedTime = reviewedTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getReviewer() {
            return reviewer;
        }

        public final void setReviewer(String reviewer) {
            this.reviewer = reviewer;
        }

        @Override
        public final Builder reviewer(String reviewer) {
            this.reviewer = reviewer;
            return this;
        }

        @Override
        public ReviewInformation build() {
            return new ReviewInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
