/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.OpsMetadata;

public class ListOpsMetadataPublisher
implements SdkPublisher<ListOpsMetadataResponse> {
    private final SsmAsyncClient client;
    private final ListOpsMetadataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOpsMetadataPublisher(SsmAsyncClient client, ListOpsMetadataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOpsMetadataPublisher(SsmAsyncClient client, ListOpsMetadataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOpsMetadataResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOpsMetadataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OpsMetadata> opsMetadataList() {
        Function<ListOpsMetadataResponse, Iterator> getIterator = response -> {
            if (response != null && response.opsMetadataList() != null) {
                return response.opsMetadataList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOpsMetadataResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOpsMetadataResponseFetcher
    implements AsyncPageFetcher<ListOpsMetadataResponse> {
        private ListOpsMetadataResponseFetcher() {
        }

        public boolean hasNextPage(ListOpsMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOpsMetadataResponse> nextPage(ListOpsMetadataResponse previousPage) {
            if (previousPage == null) {
                return ListOpsMetadataPublisher.this.client.listOpsMetadata(ListOpsMetadataPublisher.this.firstRequest);
            }
            return ListOpsMetadataPublisher.this.client.listOpsMetadata((ListOpsMetadataRequest)((Object)ListOpsMetadataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

