/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.OpsMetadata;

public class ListOpsMetadataIterable
implements SdkIterable<ListOpsMetadataResponse> {
    private final SsmClient client;
    private final ListOpsMetadataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOpsMetadataIterable(SsmClient client, ListOpsMetadataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOpsMetadataResponseFetcher();
    }

    public Iterator<ListOpsMetadataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OpsMetadata> opsMetadataList() {
        Function<ListOpsMetadataResponse, Iterator> getIterator = response -> {
            if (response != null && response.opsMetadataList() != null) {
                return response.opsMetadataList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOpsMetadataResponseFetcher
    implements SyncPageFetcher<ListOpsMetadataResponse> {
        private ListOpsMetadataResponseFetcher() {
        }

        public boolean hasNextPage(ListOpsMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOpsMetadataResponse nextPage(ListOpsMetadataResponse previousPage) {
            if (previousPage == null) {
                return ListOpsMetadataIterable.this.client.listOpsMetadata(ListOpsMetadataIterable.this.firstRequest);
            }
            return ListOpsMetadataIterable.this.client.listOpsMetadata((ListOpsMetadataRequest)((Object)ListOpsMetadataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

