/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotificationEvent {
    ALL("All"),
    IN_PROGRESS("InProgress"),
    SUCCESS("Success"),
    TIMED_OUT("TimedOut"),
    CANCELLED("Cancelled"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotificationEvent> VALUE_MAP;
    private final String value;

    private NotificationEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationEvent> knownValues() {
        EnumSet<NotificationEvent> knownValues = EnumSet.allOf(NotificationEvent.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotificationEvent.class, NotificationEvent::toString);
    }
}

