/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InstanceInformation;
import software.amazon.awssdk.services.ssm.model.InstanceInformationListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceInformationResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeInstanceInformationResponse> {
    private static final SdkField<List<InstanceInformation>> INSTANCE_INFORMATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceInformationList").getter(DescribeInstanceInformationResponse.getter(DescribeInstanceInformationResponse::instanceInformationList)).setter(DescribeInstanceInformationResponse.setter(Builder::instanceInformationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInformationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInstanceInformationResponse.getter(DescribeInstanceInformationResponse::nextToken)).setter(DescribeInstanceInformationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_INFORMATION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<InstanceInformation> instanceInformationList;
    private final String nextToken;

    private DescribeInstanceInformationResponse(BuilderImpl builder) {
        super(builder);
        this.instanceInformationList = builder.instanceInformationList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstanceInformationList() {
        return this.instanceInformationList != null && !(this.instanceInformationList instanceof SdkAutoConstructList);
    }

    public final List<InstanceInformation> instanceInformationList() {
        return this.instanceInformationList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceInformationList() ? this.instanceInformationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceInformationResponse)) {
            return false;
        }
        DescribeInstanceInformationResponse other = (DescribeInstanceInformationResponse)((Object)obj);
        return this.hasInstanceInformationList() == other.hasInstanceInformationList() && Objects.equals(this.instanceInformationList(), other.instanceInformationList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInstanceInformationResponse").add("InstanceInformationList", this.hasInstanceInformationList() ? this.instanceInformationList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceInformationList": {
                return Optional.ofNullable(clazz.cast(this.instanceInformationList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceInformationResponse, T> g) {
        return obj -> g.apply((DescribeInstanceInformationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<InstanceInformation> instanceInformationList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceInformationResponse model) {
            super(model);
            this.instanceInformationList(model.instanceInformationList);
            this.nextToken(model.nextToken);
        }

        public final List<InstanceInformation.Builder> getInstanceInformationList() {
            List<InstanceInformation.Builder> result = InstanceInformationListCopier.copyToBuilder(this.instanceInformationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder instanceInformationList(Collection<InstanceInformation> instanceInformationList) {
            this.instanceInformationList = InstanceInformationListCopier.copy(instanceInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInformationList(InstanceInformation ... instanceInformationList) {
            this.instanceInformationList(Arrays.asList(instanceInformationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInformationList(Consumer<InstanceInformation.Builder> ... instanceInformationList) {
            this.instanceInformationList(Stream.of(instanceInformationList).map(c -> (InstanceInformation)((InstanceInformation.Builder)InstanceInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceInformationList(Collection<InstanceInformation.BuilderImpl> instanceInformationList) {
            this.instanceInformationList = InstanceInformationListCopier.copyFromBuilder(instanceInformationList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceInformationResponse build() {
            return new DescribeInstanceInformationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceInformationResponse> {
        public Builder instanceInformationList(Collection<InstanceInformation> var1);

        public Builder instanceInformationList(InstanceInformation ... var1);

        public Builder instanceInformationList(Consumer<InstanceInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

