/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InventoryAttributeDataType {
    STRING("string"),
    NUMBER("number"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InventoryAttributeDataType> VALUE_MAP;
    private final String value;

    private InventoryAttributeDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InventoryAttributeDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InventoryAttributeDataType> knownValues() {
        EnumSet<InventoryAttributeDataType> knownValues = EnumSet.allOf(InventoryAttributeDataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InventoryAttributeDataType.class, InventoryAttributeDataType::toString);
    }
}

