/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInventoryResponse extends SsmResponse implements
        ToCopyableBuilder<GetInventoryResponse.Builder, GetInventoryResponse> {
    private static final SdkField<List<InventoryResultEntity>> ENTITIES_FIELD = SdkField
            .<List<InventoryResultEntity>> builder(MarshallingType.LIST)
            .memberName("Entities")
            .getter(getter(GetInventoryResponse::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InventoryResultEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(InventoryResultEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetInventoryResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InventoryResultEntity> entities;

    private final String nextToken;

    private GetInventoryResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Collection of inventory entities such as a collection of instance inventory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return Collection of inventory entities such as a collection of instance inventory.
     */
    public final List<InventoryResultEntity> entities() {
        return entities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventoryResponse)) {
            return false;
        }
        GetInventoryResponse other = (GetInventoryResponse) obj;
        return hasEntities() == other.hasEntities() && Objects.equals(entities(), other.entities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInventoryResponse").add("Entities", hasEntities() ? entities() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entities":
            return Optional.ofNullable(clazz.cast(entities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInventoryResponse, T> g) {
        return obj -> g.apply((GetInventoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInventoryResponse> {
        /**
         * <p>
         * Collection of inventory entities such as a collection of instance inventory.
         * </p>
         * 
         * @param entities
         *        Collection of inventory entities such as a collection of instance inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<InventoryResultEntity> entities);

        /**
         * <p>
         * Collection of inventory entities such as a collection of instance inventory.
         * </p>
         * 
         * @param entities
         *        Collection of inventory entities such as a collection of instance inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(InventoryResultEntity... entities);

        /**
         * <p>
         * Collection of inventory entities such as a collection of instance inventory.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InventoryResultEntity>.Builder} avoiding
         * the need to create one manually via {@link List<InventoryResultEntity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InventoryResultEntity>.Builder#build()} is called
         * immediately and its result is passed to {@link #entities(List<InventoryResultEntity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on {@link List<InventoryResultEntity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(List<InventoryResultEntity>)
         */
        Builder entities(Consumer<InventoryResultEntity.Builder>... entities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<InventoryResultEntity> entities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventoryResponse model) {
            super(model);
            entities(model.entities);
            nextToken(model.nextToken);
        }

        public final List<InventoryResultEntity.Builder> getEntities() {
            List<InventoryResultEntity.Builder> result = InventoryResultEntityListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<InventoryResultEntity.BuilderImpl> entities) {
            this.entities = InventoryResultEntityListCopier.copyFromBuilder(entities);
        }

        @Override
        @Transient
        public final Builder entities(Collection<InventoryResultEntity> entities) {
            this.entities = InventoryResultEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entities(InventoryResultEntity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entities(Consumer<InventoryResultEntity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> InventoryResultEntity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetInventoryResponse build() {
            return new GetInventoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
