/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CommandInvocationStatus {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    DELAYED("Delayed"),
    SUCCESS("Success"),
    CANCELLED("Cancelled"),
    TIMED_OUT("TimedOut"),
    FAILED("Failed"),
    CANCELLING("Cancelling"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CommandInvocationStatus> VALUE_MAP;
    private final String value;

    private CommandInvocationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommandInvocationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommandInvocationStatus> knownValues() {
        EnumSet<CommandInvocationStatus> knownValues = EnumSet.allOf(CommandInvocationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CommandInvocationStatus.class, CommandInvocationStatus::toString);
    }
}

