/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentStatus {
    CREATING("Creating"),
    ACTIVE("Active"),
    UPDATING("Updating"),
    DELETING("Deleting"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentStatus> VALUE_MAP;
    private final String value;

    private DocumentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentStatus> knownValues() {
        EnumSet<DocumentStatus> knownValues = EnumSet.allOf(DocumentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentStatus.class, DocumentStatus::toString);
    }
}

