/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateOpsItemRelatedItemRequest extends SsmRequest implements
        ToCopyableBuilder<AssociateOpsItemRelatedItemRequest.Builder, AssociateOpsItemRelatedItemRequest> {
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsItemId").getter(getter(AssociateOpsItemRelatedItemRequest::opsItemId))
            .setter(setter(Builder::opsItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()).build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationType").getter(getter(AssociateOpsItemRelatedItemRequest::associationType))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationType").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(AssociateOpsItemRelatedItemRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceUri").getter(getter(AssociateOpsItemRelatedItemRequest::resourceUri))
            .setter(setter(Builder::resourceUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_ITEM_ID_FIELD,
            ASSOCIATION_TYPE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_URI_FIELD));

    private final String opsItemId;

    private final String associationType;

    private final String resourceType;

    private final String resourceUri;

    private AssociateOpsItemRelatedItemRequest(BuilderImpl builder) {
        super(builder);
        this.opsItemId = builder.opsItemId;
        this.associationType = builder.associationType;
        this.resourceType = builder.resourceType;
        this.resourceUri = builder.resourceUri;
    }

    /**
     * <p>
     * The ID of the OpsItem to which you want to associate a resource as a related item.
     * </p>
     * 
     * @return The ID of the OpsItem to which you want to associate a resource as a related item.
     */
    public final String opsItemId() {
        return opsItemId;
    }

    /**
     * <p>
     * The type of association that you want to create between an OpsItem and a resource. OpsCenter supports
     * <code>IsParentOf</code> and <code>RelatesTo</code> association types.
     * </p>
     * 
     * @return The type of association that you want to create between an OpsItem and a resource. OpsCenter supports
     *         <code>IsParentOf</code> and <code>RelatesTo</code> association types.
     */
    public final String associationType() {
        return associationType;
    }

    /**
     * <p>
     * The type of resource that you want to associate with an OpsItem. OpsCenter supports the following types:
     * </p>
     * <p>
     * <code>AWS::SSMIncidents::IncidentRecord</code>: an Incident Manager incident. Incident Manager is a capability of
     * AWS Systems Manager.
     * </p>
     * <p>
     * <code>AWS::SSM::Document</code>: a Systems Manager (SSM) document.
     * </p>
     * 
     * @return The type of resource that you want to associate with an OpsItem. OpsCenter supports the following
     *         types:</p>
     *         <p>
     *         <code>AWS::SSMIncidents::IncidentRecord</code>: an Incident Manager incident. Incident Manager is a
     *         capability of AWS Systems Manager.
     *         </p>
     *         <p>
     *         <code>AWS::SSM::Document</code>: a Systems Manager (SSM) document.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS resource that you want to associate with the OpsItem.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS resource that you want to associate with the OpsItem.
     */
    public final String resourceUri() {
        return resourceUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(associationType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateOpsItemRelatedItemRequest)) {
            return false;
        }
        AssociateOpsItemRelatedItemRequest other = (AssociateOpsItemRelatedItemRequest) obj;
        return Objects.equals(opsItemId(), other.opsItemId()) && Objects.equals(associationType(), other.associationType())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(resourceUri(), other.resourceUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateOpsItemRelatedItemRequest").add("OpsItemId", opsItemId())
                .add("AssociationType", associationType()).add("ResourceType", resourceType()).add("ResourceUri", resourceUri())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpsItemId":
            return Optional.ofNullable(clazz.cast(opsItemId()));
        case "AssociationType":
            return Optional.ofNullable(clazz.cast(associationType()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceUri":
            return Optional.ofNullable(clazz.cast(resourceUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateOpsItemRelatedItemRequest, T> g) {
        return obj -> g.apply((AssociateOpsItemRelatedItemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateOpsItemRelatedItemRequest> {
        /**
         * <p>
         * The ID of the OpsItem to which you want to associate a resource as a related item.
         * </p>
         * 
         * @param opsItemId
         *        The ID of the OpsItem to which you want to associate a resource as a related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemId(String opsItemId);

        /**
         * <p>
         * The type of association that you want to create between an OpsItem and a resource. OpsCenter supports
         * <code>IsParentOf</code> and <code>RelatesTo</code> association types.
         * </p>
         * 
         * @param associationType
         *        The type of association that you want to create between an OpsItem and a resource. OpsCenter supports
         *        <code>IsParentOf</code> and <code>RelatesTo</code> association types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * The type of resource that you want to associate with an OpsItem. OpsCenter supports the following types:
         * </p>
         * <p>
         * <code>AWS::SSMIncidents::IncidentRecord</code>: an Incident Manager incident. Incident Manager is a
         * capability of AWS Systems Manager.
         * </p>
         * <p>
         * <code>AWS::SSM::Document</code>: a Systems Manager (SSM) document.
         * </p>
         * 
         * @param resourceType
         *        The type of resource that you want to associate with an OpsItem. OpsCenter supports the following
         *        types:</p>
         *        <p>
         *        <code>AWS::SSMIncidents::IncidentRecord</code>: an Incident Manager incident. Incident Manager is a
         *        capability of AWS Systems Manager.
         *        </p>
         *        <p>
         *        <code>AWS::SSM::Document</code>: a Systems Manager (SSM) document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS resource that you want to associate with the OpsItem.
         * </p>
         * 
         * @param resourceUri
         *        The Amazon Resource Name (ARN) of the AWS resource that you want to associate with the OpsItem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceUri(String resourceUri);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String opsItemId;

        private String associationType;

        private String resourceType;

        private String resourceUri;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateOpsItemRelatedItemRequest model) {
            super(model);
            opsItemId(model.opsItemId);
            associationType(model.associationType);
            resourceType(model.resourceType);
            resourceUri(model.resourceUri);
        }

        public final String getOpsItemId() {
            return opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        public final String getAssociationType() {
            return associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceUri() {
            return resourceUri;
        }

        @Override
        public final Builder resourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
            return this;
        }

        public final void setResourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateOpsItemRelatedItemRequest build() {
            return new AssociateOpsItemRelatedItemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
