/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemSummariesCopier;
import software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemSummary;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOpsItemRelatedItemsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListOpsItemRelatedItemsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOpsItemRelatedItemsResponse.getter(ListOpsItemRelatedItemsResponse::nextToken)).setter(ListOpsItemRelatedItemsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<OpsItemRelatedItemSummary>> SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Summaries").getter(ListOpsItemRelatedItemsResponse.getter(ListOpsItemRelatedItemsResponse::summaries)).setter(ListOpsItemRelatedItemsResponse.setter(Builder::summaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemRelatedItemSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SUMMARIES_FIELD));
    private final String nextToken;
    private final List<OpsItemRelatedItemSummary> summaries;

    private ListOpsItemRelatedItemsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.summaries = builder.summaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSummaries() {
        return this.summaries != null && !(this.summaries instanceof SdkAutoConstructList);
    }

    public final List<OpsItemRelatedItemSummary> summaries() {
        return this.summaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaries() ? this.summaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpsItemRelatedItemsResponse)) {
            return false;
        }
        ListOpsItemRelatedItemsResponse other = (ListOpsItemRelatedItemsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSummaries() == other.hasSummaries() && Objects.equals(this.summaries(), other.summaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListOpsItemRelatedItemsResponse").add("NextToken", (Object)this.nextToken()).add("Summaries", this.hasSummaries() ? this.summaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Summaries": {
                return Optional.ofNullable(clazz.cast(this.summaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOpsItemRelatedItemsResponse, T> g) {
        return obj -> g.apply((ListOpsItemRelatedItemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<OpsItemRelatedItemSummary> summaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpsItemRelatedItemsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.summaries(model.summaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<OpsItemRelatedItemSummary.Builder> getSummaries() {
            List<OpsItemRelatedItemSummary.Builder> result = OpsItemRelatedItemSummariesCopier.copyToBuilder(this.summaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder summaries(Collection<OpsItemRelatedItemSummary> summaries) {
            this.summaries = OpsItemRelatedItemSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(OpsItemRelatedItemSummary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<OpsItemRelatedItemSummary.Builder> ... summaries) {
            this.summaries(Stream.of(summaries).map(c -> (OpsItemRelatedItemSummary)((OpsItemRelatedItemSummary.Builder)OpsItemRelatedItemSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSummaries(Collection<OpsItemRelatedItemSummary.BuilderImpl> summaries) {
            this.summaries = OpsItemRelatedItemSummariesCopier.copyFromBuilder(summaries);
        }

        @Override
        public ListOpsItemRelatedItemsResponse build() {
            return new ListOpsItemRelatedItemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOpsItemRelatedItemsResponse> {
        public Builder nextToken(String var1);

        public Builder summaries(Collection<OpsItemRelatedItemSummary> var1);

        public Builder summaries(OpsItemRelatedItemSummary ... var1);

        public Builder summaries(Consumer<OpsItemRelatedItemSummary.Builder> ... var1);
    }
}

