/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComplianceSummariesResponse extends SsmResponse implements
        ToCopyableBuilder<ListComplianceSummariesResponse.Builder, ListComplianceSummariesResponse> {
    private static final SdkField<List<ComplianceSummaryItem>> COMPLIANCE_SUMMARY_ITEMS_FIELD = SdkField
            .<List<ComplianceSummaryItem>> builder(MarshallingType.LIST)
            .memberName("ComplianceSummaryItems")
            .getter(getter(ListComplianceSummariesResponse::complianceSummaryItems))
            .setter(setter(Builder::complianceSummaryItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSummaryItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComplianceSummaryItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComplianceSummaryItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListComplianceSummariesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMPLIANCE_SUMMARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ComplianceSummaryItem> complianceSummaryItems;

    private final String nextToken;

    private ListComplianceSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.complianceSummaryItems = builder.complianceSummaryItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ComplianceSummaryItems property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasComplianceSummaryItems() {
        return complianceSummaryItems != null && !(complianceSummaryItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of compliant and non-compliant summary counts based on compliance types. For example, this call returns
     * State Manager associations, patches, or custom compliance types according to the filter criteria that you
     * specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComplianceSummaryItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of compliant and non-compliant summary counts based on compliance types. For example, this call
     *         returns State Manager associations, patches, or custom compliance types according to the filter criteria
     *         that you specified.
     */
    public final List<ComplianceSummaryItem> complianceSummaryItems() {
        return complianceSummaryItems;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasComplianceSummaryItems() ? complianceSummaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComplianceSummariesResponse)) {
            return false;
        }
        ListComplianceSummariesResponse other = (ListComplianceSummariesResponse) obj;
        return hasComplianceSummaryItems() == other.hasComplianceSummaryItems()
                && Objects.equals(complianceSummaryItems(), other.complianceSummaryItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComplianceSummariesResponse")
                .add("ComplianceSummaryItems", hasComplianceSummaryItems() ? complianceSummaryItems() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceSummaryItems":
            return Optional.ofNullable(clazz.cast(complianceSummaryItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComplianceSummariesResponse, T> g) {
        return obj -> g.apply((ListComplianceSummariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListComplianceSummariesResponse> {
        /**
         * <p>
         * A list of compliant and non-compliant summary counts based on compliance types. For example, this call
         * returns State Manager associations, patches, or custom compliance types according to the filter criteria that
         * you specified.
         * </p>
         * 
         * @param complianceSummaryItems
         *        A list of compliant and non-compliant summary counts based on compliance types. For example, this call
         *        returns State Manager associations, patches, or custom compliance types according to the filter
         *        criteria that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummaryItems(Collection<ComplianceSummaryItem> complianceSummaryItems);

        /**
         * <p>
         * A list of compliant and non-compliant summary counts based on compliance types. For example, this call
         * returns State Manager associations, patches, or custom compliance types according to the filter criteria that
         * you specified.
         * </p>
         * 
         * @param complianceSummaryItems
         *        A list of compliant and non-compliant summary counts based on compliance types. For example, this call
         *        returns State Manager associations, patches, or custom compliance types according to the filter
         *        criteria that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummaryItems(ComplianceSummaryItem... complianceSummaryItems);

        /**
         * <p>
         * A list of compliant and non-compliant summary counts based on compliance types. For example, this call
         * returns State Manager associations, patches, or custom compliance types according to the filter criteria that
         * you specified.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComplianceSummaryItem>.Builder} avoiding
         * the need to create one manually via {@link List<ComplianceSummaryItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComplianceSummaryItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #complianceSummaryItems(List<ComplianceSummaryItem>)}.
         * 
         * @param complianceSummaryItems
         *        a consumer that will call methods on {@link List<ComplianceSummaryItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceSummaryItems(List<ComplianceSummaryItem>)
         */
        Builder complianceSummaryItems(Consumer<ComplianceSummaryItem.Builder>... complianceSummaryItems);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<ComplianceSummaryItem> complianceSummaryItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComplianceSummariesResponse model) {
            super(model);
            complianceSummaryItems(model.complianceSummaryItems);
            nextToken(model.nextToken);
        }

        public final Collection<ComplianceSummaryItem.Builder> getComplianceSummaryItems() {
            if (complianceSummaryItems instanceof SdkAutoConstructList) {
                return null;
            }
            return complianceSummaryItems != null ? complianceSummaryItems.stream().map(ComplianceSummaryItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder complianceSummaryItems(Collection<ComplianceSummaryItem> complianceSummaryItems) {
            this.complianceSummaryItems = ComplianceSummaryItemListCopier.copy(complianceSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceSummaryItems(ComplianceSummaryItem... complianceSummaryItems) {
            complianceSummaryItems(Arrays.asList(complianceSummaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceSummaryItems(Consumer<ComplianceSummaryItem.Builder>... complianceSummaryItems) {
            complianceSummaryItems(Stream.of(complianceSummaryItems)
                    .map(c -> ComplianceSummaryItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComplianceSummaryItems(Collection<ComplianceSummaryItem.BuilderImpl> complianceSummaryItems) {
            this.complianceSummaryItems = ComplianceSummaryItemListCopier.copyFromBuilder(complianceSummaryItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListComplianceSummariesResponse build() {
            return new ListComplianceSummariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
