/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.OpsItemSummariesCopier;
import software.amazon.awssdk.services.ssm.model.OpsItemSummary;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOpsItemsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeOpsItemsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOpsItemsResponse.getter(DescribeOpsItemsResponse::nextToken)).setter(DescribeOpsItemsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<OpsItemSummary>> OPS_ITEM_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpsItemSummaries").getter(DescribeOpsItemsResponse.getter(DescribeOpsItemsResponse::opsItemSummaries)).setter(DescribeOpsItemsResponse.setter(Builder::opsItemSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, OPS_ITEM_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<OpsItemSummary> opsItemSummaries;

    private DescribeOpsItemsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.opsItemSummaries = builder.opsItemSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasOpsItemSummaries() {
        return this.opsItemSummaries != null && !(this.opsItemSummaries instanceof SdkAutoConstructList);
    }

    public List<OpsItemSummary> opsItemSummaries() {
        return this.opsItemSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpsItemSummaries() ? this.opsItemSummaries() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOpsItemsResponse)) {
            return false;
        }
        DescribeOpsItemsResponse other = (DescribeOpsItemsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasOpsItemSummaries() == other.hasOpsItemSummaries() && Objects.equals(this.opsItemSummaries(), other.opsItemSummaries());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOpsItemsResponse").add("NextToken", (Object)this.nextToken()).add("OpsItemSummaries", this.hasOpsItemSummaries() ? this.opsItemSummaries() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "OpsItemSummaries": {
                return Optional.ofNullable(clazz.cast(this.opsItemSummaries()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOpsItemsResponse, T> g) {
        return obj -> g.apply((DescribeOpsItemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<OpsItemSummary> opsItemSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOpsItemsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.opsItemSummaries(model.opsItemSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<OpsItemSummary.Builder> getOpsItemSummaries() {
            if (this.opsItemSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.opsItemSummaries != null ? (Collection)this.opsItemSummaries.stream().map(OpsItemSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder opsItemSummaries(Collection<OpsItemSummary> opsItemSummaries) {
            this.opsItemSummaries = OpsItemSummariesCopier.copy(opsItemSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opsItemSummaries(OpsItemSummary ... opsItemSummaries) {
            this.opsItemSummaries(Arrays.asList(opsItemSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opsItemSummaries(Consumer<OpsItemSummary.Builder> ... opsItemSummaries) {
            this.opsItemSummaries(Stream.of(opsItemSummaries).map(c -> (OpsItemSummary)((OpsItemSummary.Builder)OpsItemSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOpsItemSummaries(Collection<OpsItemSummary.BuilderImpl> opsItemSummaries) {
            this.opsItemSummaries = OpsItemSummariesCopier.copyFromBuilder(opsItemSummaries);
        }

        @Override
        public DescribeOpsItemsResponse build() {
            return new DescribeOpsItemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOpsItemsResponse> {
        public Builder nextToken(String var1);

        public Builder opsItemSummaries(Collection<OpsItemSummary> var1);

        public Builder opsItemSummaries(OpsItemSummary ... var1);

        public Builder opsItemSummaries(Consumer<OpsItemSummary.Builder> ... var1);
    }
}

