/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.OpsItemParameterNamesListCopier;
import software.amazon.awssdk.services.ssm.model.SsmException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpsItemInvalidParameterException
extends SsmException
implements ToCopyableBuilder<Builder, OpsItemInvalidParameterException> {
    private static final SdkField<List<String>> PARAMETER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterNames").getter(OpsItemInvalidParameterException.getter(OpsItemInvalidParameterException::parameterNames)).setter(OpsItemInvalidParameterException.setter(Builder::parameterNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> parameterNames;

    private OpsItemInvalidParameterException(BuilderImpl builder) {
        super(builder);
        this.parameterNames = builder.parameterNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasParameterNames() {
        return this.parameterNames != null && !(this.parameterNames instanceof SdkAutoConstructList);
    }

    public List<String> parameterNames() {
        return this.parameterNames;
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpsItemInvalidParameterException, T> g) {
        return obj -> g.apply((OpsItemInvalidParameterException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmException.BuilderImpl
    implements Builder {
        private List<String> parameterNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpsItemInvalidParameterException model) {
            super(model);
            this.parameterNames(model.parameterNames);
        }

        public final Collection<String> getParameterNames() {
            if (this.parameterNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parameterNames;
        }

        @Override
        public final Builder parameterNames(Collection<String> parameterNames) {
            this.parameterNames = OpsItemParameterNamesListCopier.copy(parameterNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNames(String ... parameterNames) {
            this.parameterNames(Arrays.asList(parameterNames));
            return this;
        }

        public final void setParameterNames(Collection<String> parameterNames) {
            this.parameterNames = OpsItemParameterNamesListCopier.copy(parameterNames);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public OpsItemInvalidParameterException build() {
            return new OpsItemInvalidParameterException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpsItemInvalidParameterException>,
    SsmException.Builder {
        public Builder parameterNames(Collection<String> var1);

        public Builder parameterNames(String ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

