/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reserved for future use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionManagerOutputUrl implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionManagerOutputUrl.Builder, SessionManagerOutputUrl> {
    private static final SdkField<String> S3_OUTPUT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SessionManagerOutputUrl::s3OutputUrl)).setter(setter(Builder::s3OutputUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputUrl").build()).build();

    private static final SdkField<String> CLOUD_WATCH_OUTPUT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SessionManagerOutputUrl::cloudWatchOutputUrl)).setter(setter(Builder::cloudWatchOutputUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchOutputUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_URL_FIELD,
            CLOUD_WATCH_OUTPUT_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3OutputUrl;

    private final String cloudWatchOutputUrl;

    private SessionManagerOutputUrl(BuilderImpl builder) {
        this.s3OutputUrl = builder.s3OutputUrl;
        this.cloudWatchOutputUrl = builder.cloudWatchOutputUrl;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String s3OutputUrl() {
        return s3OutputUrl;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String cloudWatchOutputUrl() {
        return cloudWatchOutputUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchOutputUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionManagerOutputUrl)) {
            return false;
        }
        SessionManagerOutputUrl other = (SessionManagerOutputUrl) obj;
        return Objects.equals(s3OutputUrl(), other.s3OutputUrl())
                && Objects.equals(cloudWatchOutputUrl(), other.cloudWatchOutputUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SessionManagerOutputUrl").add("S3OutputUrl", s3OutputUrl())
                .add("CloudWatchOutputUrl", cloudWatchOutputUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3OutputUrl":
            return Optional.ofNullable(clazz.cast(s3OutputUrl()));
        case "CloudWatchOutputUrl":
            return Optional.ofNullable(clazz.cast(cloudWatchOutputUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionManagerOutputUrl, T> g) {
        return obj -> g.apply((SessionManagerOutputUrl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionManagerOutputUrl> {
        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param s3OutputUrl
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputUrl(String s3OutputUrl);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param cloudWatchOutputUrl
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchOutputUrl(String cloudWatchOutputUrl);
    }

    static final class BuilderImpl implements Builder {
        private String s3OutputUrl;

        private String cloudWatchOutputUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionManagerOutputUrl model) {
            s3OutputUrl(model.s3OutputUrl);
            cloudWatchOutputUrl(model.cloudWatchOutputUrl);
        }

        public final String getS3OutputUrl() {
            return s3OutputUrl;
        }

        @Override
        public final Builder s3OutputUrl(String s3OutputUrl) {
            this.s3OutputUrl = s3OutputUrl;
            return this;
        }

        public final void setS3OutputUrl(String s3OutputUrl) {
            this.s3OutputUrl = s3OutputUrl;
        }

        public final String getCloudWatchOutputUrl() {
            return cloudWatchOutputUrl;
        }

        @Override
        public final Builder cloudWatchOutputUrl(String cloudWatchOutputUrl) {
            this.cloudWatchOutputUrl = cloudWatchOutputUrl;
            return this;
        }

        public final void setCloudWatchOutputUrl(String cloudWatchOutputUrl) {
            this.cloudWatchOutputUrl = cloudWatchOutputUrl;
        }

        @Override
        public SessionManagerOutputUrl build() {
            return new SessionManagerOutputUrl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
