/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDocumentRequest extends SsmRequest implements
        ToCopyableBuilder<DeleteDocumentRequest.Builder, DeleteDocumentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteDocumentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteDocumentRequest::documentVersion)).setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteDocumentRequest::versionName)).setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteDocumentRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DOCUMENT_VERSION_FIELD, VERSION_NAME_FIELD, FORCE_FIELD));

    private final String name;

    private final String documentVersion;

    private final String versionName;

    private final Boolean force;

    private DeleteDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.versionName = builder.versionName;
        this.force = builder.force;
    }

    /**
     * <p>
     * The name of the document.
     * </p>
     * 
     * @return The name of the document.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version of the document that you want to delete. If not provided, all versions of the document are deleted.
     * </p>
     * 
     * @return The version of the document that you want to delete. If not provided, all versions of the document are
     *         deleted.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The version name of the document that you want to delete. If not provided, all versions of the document are
     * deleted.
     * </p>
     * 
     * @return The version name of the document that you want to delete. If not provided, all versions of the document
     *         are deleted.
     */
    public String versionName() {
        return versionName;
    }

    /**
     * <p>
     * Some SSM document types require that you specify a <code>Force</code> flag before you can delete the document.
     * For example, you must specify a <code>Force</code> flag to delete a document of type
     * <code>ApplicationConfigurationSchema</code>. You can restrict access to the <code>Force</code> flag in an AWS
     * Identity and Access Management (IAM) policy.
     * </p>
     * 
     * @return Some SSM document types require that you specify a <code>Force</code> flag before you can delete the
     *         document. For example, you must specify a <code>Force</code> flag to delete a document of type
     *         <code>ApplicationConfigurationSchema</code>. You can restrict access to the <code>Force</code> flag in an
     *         AWS Identity and Access Management (IAM) policy.
     */
    public Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDocumentRequest)) {
            return false;
        }
        DeleteDocumentRequest other = (DeleteDocumentRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(versionName(), other.versionName()) && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteDocumentRequest").add("Name", name()).add("DocumentVersion", documentVersion())
                .add("VersionName", versionName()).add("Force", force()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "Force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDocumentRequest, T> g) {
        return obj -> g.apply((DeleteDocumentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDocumentRequest> {
        /**
         * <p>
         * The name of the document.
         * </p>
         * 
         * @param name
         *        The name of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the document that you want to delete. If not provided, all versions of the document are
         * deleted.
         * </p>
         * 
         * @param documentVersion
         *        The version of the document that you want to delete. If not provided, all versions of the document are
         *        deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The version name of the document that you want to delete. If not provided, all versions of the document are
         * deleted.
         * </p>
         * 
         * @param versionName
         *        The version name of the document that you want to delete. If not provided, all versions of the
         *        document are deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * Some SSM document types require that you specify a <code>Force</code> flag before you can delete the
         * document. For example, you must specify a <code>Force</code> flag to delete a document of type
         * <code>ApplicationConfigurationSchema</code>. You can restrict access to the <code>Force</code> flag in an AWS
         * Identity and Access Management (IAM) policy.
         * </p>
         * 
         * @param force
         *        Some SSM document types require that you specify a <code>Force</code> flag before you can delete the
         *        document. For example, you must specify a <code>Force</code> flag to delete a document of type
         *        <code>ApplicationConfigurationSchema</code>. You can restrict access to the <code>Force</code> flag in
         *        an AWS Identity and Access Management (IAM) policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String name;

        private String documentVersion;

        private String versionName;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDocumentRequest model) {
            super(model);
            name(model.name);
            documentVersion(model.documentVersion);
            versionName(model.versionName);
            force(model.force);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getVersionName() {
            return versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDocumentRequest build() {
            return new DeleteDocumentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
