/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDocumentResponse extends SsmResponse implements
        ToCopyableBuilder<CreateDocumentResponse.Builder, CreateDocumentResponse> {
    private static final SdkField<DocumentDescription> DOCUMENT_DESCRIPTION_FIELD = SdkField
            .<DocumentDescription> builder(MarshallingType.SDK_POJO).getter(getter(CreateDocumentResponse::documentDescription))
            .setter(setter(Builder::documentDescription)).constructor(DocumentDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_DESCRIPTION_FIELD));

    private final DocumentDescription documentDescription;

    private CreateDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.documentDescription = builder.documentDescription;
    }

    /**
     * <p>
     * Information about the Systems Manager document.
     * </p>
     * 
     * @return Information about the Systems Manager document.
     */
    public DocumentDescription documentDescription() {
        return documentDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDocumentResponse)) {
            return false;
        }
        CreateDocumentResponse other = (CreateDocumentResponse) obj;
        return Objects.equals(documentDescription(), other.documentDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDocumentResponse").add("DocumentDescription", documentDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentDescription":
            return Optional.ofNullable(clazz.cast(documentDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDocumentResponse, T> g) {
        return obj -> g.apply((CreateDocumentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDocumentResponse> {
        /**
         * <p>
         * Information about the Systems Manager document.
         * </p>
         * 
         * @param documentDescription
         *        Information about the Systems Manager document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDescription(DocumentDescription documentDescription);

        /**
         * <p>
         * Information about the Systems Manager document.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentDescription.Builder} avoiding the need
         * to create one manually via {@link DocumentDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #documentDescription(DocumentDescription)}.
         * 
         * @param documentDescription
         *        a consumer that will call methods on {@link DocumentDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentDescription(DocumentDescription)
         */
        default Builder documentDescription(Consumer<DocumentDescription.Builder> documentDescription) {
            return documentDescription(DocumentDescription.builder().applyMutation(documentDescription).build());
        }
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private DocumentDescription documentDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDocumentResponse model) {
            super(model);
            documentDescription(model.documentDescription);
        }

        public final DocumentDescription.Builder getDocumentDescription() {
            return documentDescription != null ? documentDescription.toBuilder() : null;
        }

        @Override
        public final Builder documentDescription(DocumentDescription documentDescription) {
            this.documentDescription = documentDescription;
            return this;
        }

        public final void setDocumentDescription(DocumentDescription.BuilderImpl documentDescription) {
            this.documentDescription = documentDescription != null ? documentDescription.build() : null;
        }

        @Override
        public CreateDocumentResponse build() {
            return new CreateDocumentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
