/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that includes attributes that describe a document attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachmentContent implements SdkPojo, Serializable,
        ToCopyableBuilder<AttachmentContent.Builder, AttachmentContent> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachmentContent::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Long> SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(AttachmentContent::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<String> HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachmentContent::hash)).setter(setter(Builder::hash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hash").build()).build();

    private static final SdkField<String> HASH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachmentContent::hashTypeAsString)).setter(setter(Builder::hashType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HashType").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachmentContent::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SIZE_FIELD,
            HASH_FIELD, HASH_TYPE_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Long size;

    private final String hash;

    private final String hashType;

    private final String url;

    private AttachmentContent(BuilderImpl builder) {
        this.name = builder.name;
        this.size = builder.size;
        this.hash = builder.hash;
        this.hashType = builder.hashType;
        this.url = builder.url;
    }

    /**
     * <p>
     * The name of an attachment.
     * </p>
     * 
     * @return The name of an attachment.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The size of an attachment in bytes.
     * </p>
     * 
     * @return The size of an attachment in bytes.
     */
    public Long size() {
        return size;
    }

    /**
     * <p>
     * The cryptographic hash value of the document content.
     * </p>
     * 
     * @return The cryptographic hash value of the document content.
     */
    public String hash() {
        return hash;
    }

    /**
     * <p>
     * The hash algorithm used to calculate the hash value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hashType} will
     * return {@link AttachmentHashType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hashTypeAsString}.
     * </p>
     * 
     * @return The hash algorithm used to calculate the hash value.
     * @see AttachmentHashType
     */
    public AttachmentHashType hashType() {
        return AttachmentHashType.fromValue(hashType);
    }

    /**
     * <p>
     * The hash algorithm used to calculate the hash value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hashType} will
     * return {@link AttachmentHashType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hashTypeAsString}.
     * </p>
     * 
     * @return The hash algorithm used to calculate the hash value.
     * @see AttachmentHashType
     */
    public String hashTypeAsString() {
        return hashType;
    }

    /**
     * <p>
     * The URL location of the attachment content.
     * </p>
     * 
     * @return The URL location of the attachment content.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(hash());
        hashCode = 31 * hashCode + Objects.hashCode(hashTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentContent)) {
            return false;
        }
        AttachmentContent other = (AttachmentContent) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(size(), other.size())
                && Objects.equals(hash(), other.hash()) && Objects.equals(hashTypeAsString(), other.hashTypeAsString())
                && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AttachmentContent").add("Name", name()).add("Size", size()).add("Hash", hash())
                .add("HashType", hashTypeAsString()).add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "Hash":
            return Optional.ofNullable(clazz.cast(hash()));
        case "HashType":
            return Optional.ofNullable(clazz.cast(hashTypeAsString()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachmentContent, T> g) {
        return obj -> g.apply((AttachmentContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttachmentContent> {
        /**
         * <p>
         * The name of an attachment.
         * </p>
         * 
         * @param name
         *        The name of an attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The size of an attachment in bytes.
         * </p>
         * 
         * @param size
         *        The size of an attachment in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);

        /**
         * <p>
         * The cryptographic hash value of the document content.
         * </p>
         * 
         * @param hash
         *        The cryptographic hash value of the document content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hash(String hash);

        /**
         * <p>
         * The hash algorithm used to calculate the hash value.
         * </p>
         * 
         * @param hashType
         *        The hash algorithm used to calculate the hash value.
         * @see AttachmentHashType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentHashType
         */
        Builder hashType(String hashType);

        /**
         * <p>
         * The hash algorithm used to calculate the hash value.
         * </p>
         * 
         * @param hashType
         *        The hash algorithm used to calculate the hash value.
         * @see AttachmentHashType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentHashType
         */
        Builder hashType(AttachmentHashType hashType);

        /**
         * <p>
         * The URL location of the attachment content.
         * </p>
         * 
         * @param url
         *        The URL location of the attachment content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Long size;

        private String hash;

        private String hashType;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachmentContent model) {
            name(model.name);
            size(model.size);
            hash(model.hash);
            hashType(model.hashType);
            url(model.url);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Long getSize() {
            return size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public final String getHash() {
            return hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        public final String getHashType() {
            return hashType;
        }

        @Override
        public final Builder hashType(String hashType) {
            this.hashType = hashType;
            return this;
        }

        @Override
        public final Builder hashType(AttachmentHashType hashType) {
            this.hashType(hashType == null ? null : hashType.toString());
            return this;
        }

        public final void setHashType(String hashType) {
            this.hashType = hashType;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public AttachmentContent build() {
            return new AttachmentContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
