/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a scheduled execution for a maintenance window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledWindowExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledWindowExecution.Builder, ScheduledWindowExecution> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduledWindowExecution::windowId)).setter(setter(Builder::windowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduledWindowExecution::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> EXECUTION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduledWindowExecution::executionTime)).setter(setter(Builder::executionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, NAME_FIELD,
            EXECUTION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String windowId;

    private final String name;

    private final String executionTime;

    private ScheduledWindowExecution(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.executionTime = builder.executionTime;
    }

    /**
     * <p>
     * The ID of the maintenance window to be run.
     * </p>
     * 
     * @return The ID of the maintenance window to be run.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The name of the maintenance window to be run.
     * </p>
     * 
     * @return The name of the maintenance window to be run.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The time, in ISO-8601 Extended format, that the maintenance window is scheduled to be run.
     * </p>
     * 
     * @return The time, in ISO-8601 Extended format, that the maintenance window is scheduled to be run.
     */
    public String executionTime() {
        return executionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(executionTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledWindowExecution)) {
            return false;
        }
        ScheduledWindowExecution other = (ScheduledWindowExecution) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(name(), other.name())
                && Objects.equals(executionTime(), other.executionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ScheduledWindowExecution").add("WindowId", windowId()).add("Name", name())
                .add("ExecutionTime", executionTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.ofNullable(clazz.cast(windowId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ExecutionTime":
            return Optional.ofNullable(clazz.cast(executionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledWindowExecution, T> g) {
        return obj -> g.apply((ScheduledWindowExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledWindowExecution> {
        /**
         * <p>
         * The ID of the maintenance window to be run.
         * </p>
         * 
         * @param windowId
         *        The ID of the maintenance window to be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The name of the maintenance window to be run.
         * </p>
         * 
         * @param name
         *        The name of the maintenance window to be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time, in ISO-8601 Extended format, that the maintenance window is scheduled to be run.
         * </p>
         * 
         * @param executionTime
         *        The time, in ISO-8601 Extended format, that the maintenance window is scheduled to be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTime(String executionTime);
    }

    static final class BuilderImpl implements Builder {
        private String windowId;

        private String name;

        private String executionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledWindowExecution model) {
            windowId(model.windowId);
            name(model.name);
            executionTime(model.executionTime);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getExecutionTime() {
            return executionTime;
        }

        @Override
        public final Builder executionTime(String executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final void setExecutionTime(String executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public ScheduledWindowExecution build() {
            return new ScheduledWindowExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
