/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specified sync name was not found.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDataSyncNotFoundException extends SsmException implements
        ToCopyableBuilder<ResourceDataSyncNotFoundException.Builder, ResourceDataSyncNotFoundException> {
    private static final SdkField<String> SYNC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceDataSyncNotFoundException::syncName)).setter(setter(Builder::syncName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncName").build()).build();

    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceDataSyncNotFoundException::syncType)).setter(setter(Builder::syncType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_NAME_FIELD,
            SYNC_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String syncName;

    private final String syncType;

    private ResourceDataSyncNotFoundException(BuilderImpl builder) {
        super(builder);
        this.syncName = builder.syncName;
        this.syncType = builder.syncType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the SyncName property for this object.
     * 
     * @return The value of the SyncName property for this object.
     */
    public String syncName() {
        return syncName;
    }

    /**
     * Returns the value of the SyncType property for this object.
     * 
     * @return The value of the SyncType property for this object.
     */
    public String syncType() {
        return syncType;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDataSyncNotFoundException, T> g) {
        return obj -> g.apply((ResourceDataSyncNotFoundException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDataSyncNotFoundException>, SsmException.Builder {
        /**
         * Sets the value of the SyncName property for this object.
         *
         * @param syncName
         *        The new value for the SyncName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncName(String syncName);

        /**
         * Sets the value of the SyncType property for this object.
         *
         * @param syncType
         *        The new value for the SyncType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncType(String syncType);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends SsmException.BuilderImpl implements Builder {
        private String syncName;

        private String syncType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataSyncNotFoundException model) {
            super(model);
            syncName(model.syncName);
            syncType(model.syncType);
        }

        public final String getSyncName() {
            return syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        public final String getSyncType() {
            return syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ResourceDataSyncNotFoundException build() {
            return new ResourceDataSyncNotFoundException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
