/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterPatchBaselineForPatchGroupRequest extends SsmRequest implements
        ToCopyableBuilder<RegisterPatchBaselineForPatchGroupRequest.Builder, RegisterPatchBaselineForPatchGroupRequest> {
    private static final SdkField<String> BASELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterPatchBaselineForPatchGroupRequest::baselineId)).setter(setter(Builder::baselineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineId").build()).build();

    private static final SdkField<String> PATCH_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterPatchBaselineForPatchGroupRequest::patchGroup)).setter(setter(Builder::patchGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_ID_FIELD,
            PATCH_GROUP_FIELD));

    private final String baselineId;

    private final String patchGroup;

    private RegisterPatchBaselineForPatchGroupRequest(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
        this.patchGroup = builder.patchGroup;
    }

    /**
     * <p>
     * The ID of the patch baseline to register the patch group with.
     * </p>
     * 
     * @return The ID of the patch baseline to register the patch group with.
     */
    public String baselineId() {
        return baselineId;
    }

    /**
     * <p>
     * The name of the patch group that should be registered with the patch baseline.
     * </p>
     * 
     * @return The name of the patch group that should be registered with the patch baseline.
     */
    public String patchGroup() {
        return patchGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(patchGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterPatchBaselineForPatchGroupRequest)) {
            return false;
        }
        RegisterPatchBaselineForPatchGroupRequest other = (RegisterPatchBaselineForPatchGroupRequest) obj;
        return Objects.equals(baselineId(), other.baselineId()) && Objects.equals(patchGroup(), other.patchGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RegisterPatchBaselineForPatchGroupRequest").add("BaselineId", baselineId())
                .add("PatchGroup", patchGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineId":
            return Optional.ofNullable(clazz.cast(baselineId()));
        case "PatchGroup":
            return Optional.ofNullable(clazz.cast(patchGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterPatchBaselineForPatchGroupRequest, T> g) {
        return obj -> g.apply((RegisterPatchBaselineForPatchGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterPatchBaselineForPatchGroupRequest> {
        /**
         * <p>
         * The ID of the patch baseline to register the patch group with.
         * </p>
         * 
         * @param baselineId
         *        The ID of the patch baseline to register the patch group with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);

        /**
         * <p>
         * The name of the patch group that should be registered with the patch baseline.
         * </p>
         * 
         * @param patchGroup
         *        The name of the patch group that should be registered with the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String baselineId;

        private String patchGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterPatchBaselineForPatchGroupRequest model) {
            super(model);
            baselineId(model.baselineId);
            patchGroup(model.patchGroup);
        }

        public final String getBaselineId() {
            return baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterPatchBaselineForPatchGroupRequest build() {
            return new RegisterPatchBaselineForPatchGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
