/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The EffectivePatch structure defines metadata about a patch along with the approval state of the patch in a
 * particular patch baseline. The approval state includes information about whether the patch is currently approved, due
 * to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch was or will be approved.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EffectivePatch implements SdkPojo, Serializable, ToCopyableBuilder<EffectivePatch.Builder, EffectivePatch> {
    private static final SdkField<Patch> PATCH_FIELD = SdkField.<Patch> builder(MarshallingType.SDK_POJO)
            .getter(getter(EffectivePatch::patch)).setter(setter(Builder::patch)).constructor(Patch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Patch").build()).build();

    private static final SdkField<PatchStatus> PATCH_STATUS_FIELD = SdkField.<PatchStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(EffectivePatch::patchStatus)).setter(setter(Builder::patchStatus)).constructor(PatchStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCH_FIELD,
            PATCH_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Patch patch;

    private final PatchStatus patchStatus;

    private EffectivePatch(BuilderImpl builder) {
        this.patch = builder.patch;
        this.patchStatus = builder.patchStatus;
    }

    /**
     * <p>
     * Provides metadata for a patch, including information such as the KB ID, severity, classification and a URL for
     * where more information can be obtained about the patch.
     * </p>
     * 
     * @return Provides metadata for a patch, including information such as the KB ID, severity, classification and a
     *         URL for where more information can be obtained about the patch.
     */
    public Patch patch() {
        return patch;
    }

    /**
     * <p>
     * The status of the patch in a patch baseline. This includes information about whether the patch is currently
     * approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch was or
     * will be approved.
     * </p>
     * 
     * @return The status of the patch in a patch baseline. This includes information about whether the patch is
     *         currently approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the
     *         date the patch was or will be approved.
     */
    public PatchStatus patchStatus() {
        return patchStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patch());
        hashCode = 31 * hashCode + Objects.hashCode(patchStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectivePatch)) {
            return false;
        }
        EffectivePatch other = (EffectivePatch) obj;
        return Objects.equals(patch(), other.patch()) && Objects.equals(patchStatus(), other.patchStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EffectivePatch").add("Patch", patch()).add("PatchStatus", patchStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Patch":
            return Optional.ofNullable(clazz.cast(patch()));
        case "PatchStatus":
            return Optional.ofNullable(clazz.cast(patchStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EffectivePatch, T> g) {
        return obj -> g.apply((EffectivePatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EffectivePatch> {
        /**
         * <p>
         * Provides metadata for a patch, including information such as the KB ID, severity, classification and a URL
         * for where more information can be obtained about the patch.
         * </p>
         * 
         * @param patch
         *        Provides metadata for a patch, including information such as the KB ID, severity, classification and a
         *        URL for where more information can be obtained about the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patch(Patch patch);

        /**
         * <p>
         * Provides metadata for a patch, including information such as the KB ID, severity, classification and a URL
         * for where more information can be obtained about the patch.
         * </p>
         * This is a convenience that creates an instance of the {@link Patch.Builder} avoiding the need to create one
         * manually via {@link Patch#builder()}.
         *
         * When the {@link Consumer} completes, {@link Patch.Builder#build()} is called immediately and its result is
         * passed to {@link #patch(Patch)}.
         * 
         * @param patch
         *        a consumer that will call methods on {@link Patch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patch(Patch)
         */
        default Builder patch(Consumer<Patch.Builder> patch) {
            return patch(Patch.builder().applyMutation(patch).build());
        }

        /**
         * <p>
         * The status of the patch in a patch baseline. This includes information about whether the patch is currently
         * approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch
         * was or will be approved.
         * </p>
         * 
         * @param patchStatus
         *        The status of the patch in a patch baseline. This includes information about whether the patch is
         *        currently approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the
         *        date the patch was or will be approved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchStatus(PatchStatus patchStatus);

        /**
         * <p>
         * The status of the patch in a patch baseline. This includes information about whether the patch is currently
         * approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch
         * was or will be approved.
         * </p>
         * This is a convenience that creates an instance of the {@link PatchStatus.Builder} avoiding the need to create
         * one manually via {@link PatchStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link PatchStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #patchStatus(PatchStatus)}.
         * 
         * @param patchStatus
         *        a consumer that will call methods on {@link PatchStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patchStatus(PatchStatus)
         */
        default Builder patchStatus(Consumer<PatchStatus.Builder> patchStatus) {
            return patchStatus(PatchStatus.builder().applyMutation(patchStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Patch patch;

        private PatchStatus patchStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectivePatch model) {
            patch(model.patch);
            patchStatus(model.patchStatus);
        }

        public final Patch.Builder getPatch() {
            return patch != null ? patch.toBuilder() : null;
        }

        @Override
        public final Builder patch(Patch patch) {
            this.patch = patch;
            return this;
        }

        public final void setPatch(Patch.BuilderImpl patch) {
            this.patch = patch != null ? patch.build() : null;
        }

        public final PatchStatus.Builder getPatchStatus() {
            return patchStatus != null ? patchStatus.toBuilder() : null;
        }

        @Override
        public final Builder patchStatus(PatchStatus patchStatus) {
            this.patchStatus = patchStatus;
            return this;
        }

        public final void setPatchStatus(PatchStatus.BuilderImpl patchStatus) {
            this.patchStatus = patchStatus != null ? patchStatus.build() : null;
        }

        @Override
        public EffectivePatch build() {
            return new EffectivePatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
