/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.CloudWatchOutputConfig;
import software.amazon.awssdk.services.ssm.model.DocumentHashType;
import software.amazon.awssdk.services.ssm.model.InstanceIdListCopier;
import software.amazon.awssdk.services.ssm.model.NotificationConfig;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendCommandRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, SendCommandRequest> {
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SendCommandRequest.getter(SendCommandRequest::instanceIds)).setter(SendCommandRequest.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SendCommandRequest.getter(SendCommandRequest::targets)).setter(SendCommandRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendCommandRequest.getter(SendCommandRequest::documentName)).setter(SendCommandRequest.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendCommandRequest.getter(SendCommandRequest::documentVersion)).setter(SendCommandRequest.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> DOCUMENT_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendCommandRequest.getter(SendCommandRequest::documentHash)).setter(SendCommandRequest.setter(Builder::documentHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentHash").build()}).build();
    private static final SdkField<String> DOCUMENT_HASH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendCommandRequest.getter(SendCommandRequest::documentHashTypeAsString)).setter(SendCommandRequest.setter(Builder::documentHashType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentHashType").build()}).build();
    private static final SdkField<Integer> TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SendCommandRequest.getter(SendCommandRequest::timeoutSeconds)).setter(SendCommandRequest.setter(Builder::timeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutSeconds").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendCommandRequest.getter(SendCommandRequest::comment)).setter(SendCommandRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(SendCommandRequest.getter(SendCommandRequest::parameters)).setter(SendCommandRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> OUTPUT_S3_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendCommandRequest.getter(SendCommandRequest::outputS3Region)).setter(SendCommandRequest.setter(Builder::outputS3Region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Region").build()}).build();
    private static final SdkField<String> OUTPUT_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendCommandRequest.getter(SendCommandRequest::outputS3BucketName)).setter(SendCommandRequest.setter(Builder::outputS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3BucketName").build()}).build();
    private static final SdkField<String> OUTPUT_S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendCommandRequest.getter(SendCommandRequest::outputS3KeyPrefix)).setter(SendCommandRequest.setter(Builder::outputS3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3KeyPrefix").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendCommandRequest.getter(SendCommandRequest::maxConcurrency)).setter(SendCommandRequest.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendCommandRequest.getter(SendCommandRequest::maxErrors)).setter(SendCommandRequest.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendCommandRequest.getter(SendCommandRequest::serviceRoleArn)).setter(SendCommandRequest.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()}).build();
    private static final SdkField<NotificationConfig> NOTIFICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SendCommandRequest.getter(SendCommandRequest::notificationConfig)).setter(SendCommandRequest.setter(Builder::notificationConfig)).constructor(NotificationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfig").build()}).build();
    private static final SdkField<CloudWatchOutputConfig> CLOUD_WATCH_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SendCommandRequest.getter(SendCommandRequest::cloudWatchOutputConfig)).setter(SendCommandRequest.setter(Builder::cloudWatchOutputConfig)).constructor(CloudWatchOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchOutputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IDS_FIELD, TARGETS_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, DOCUMENT_HASH_FIELD, DOCUMENT_HASH_TYPE_FIELD, TIMEOUT_SECONDS_FIELD, COMMENT_FIELD, PARAMETERS_FIELD, OUTPUT_S3_REGION_FIELD, OUTPUT_S3_BUCKET_NAME_FIELD, OUTPUT_S3_KEY_PREFIX_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, SERVICE_ROLE_ARN_FIELD, NOTIFICATION_CONFIG_FIELD, CLOUD_WATCH_OUTPUT_CONFIG_FIELD));
    private final List<String> instanceIds;
    private final List<Target> targets;
    private final String documentName;
    private final String documentVersion;
    private final String documentHash;
    private final String documentHashType;
    private final Integer timeoutSeconds;
    private final String comment;
    private final Map<String, List<String>> parameters;
    private final String outputS3Region;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;
    private final String maxConcurrency;
    private final String maxErrors;
    private final String serviceRoleArn;
    private final NotificationConfig notificationConfig;
    private final CloudWatchOutputConfig cloudWatchOutputConfig;

    private SendCommandRequest(BuilderImpl builder) {
        super(builder);
        this.instanceIds = builder.instanceIds;
        this.targets = builder.targets;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.documentHash = builder.documentHash;
        this.documentHashType = builder.documentHashType;
        this.timeoutSeconds = builder.timeoutSeconds;
        this.comment = builder.comment;
        this.parameters = builder.parameters;
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.notificationConfig = builder.notificationConfig;
        this.cloudWatchOutputConfig = builder.cloudWatchOutputConfig;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String documentName() {
        return this.documentName;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public String documentHash() {
        return this.documentHash;
    }

    public DocumentHashType documentHashType() {
        return DocumentHashType.fromValue(this.documentHashType);
    }

    public String documentHashTypeAsString() {
        return this.documentHashType;
    }

    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public String comment() {
        return this.comment;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public String outputS3Region() {
        return this.outputS3Region;
    }

    public String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public NotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    public CloudWatchOutputConfig cloudWatchOutputConfig() {
        return this.cloudWatchOutputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentHashTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Region());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchOutputConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCommandRequest)) {
            return false;
        }
        SendCommandRequest other = (SendCommandRequest)((Object)obj);
        return Objects.equals(this.instanceIds(), other.instanceIds()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.documentHash(), other.documentHash()) && Objects.equals(this.documentHashTypeAsString(), other.documentHashTypeAsString()) && Objects.equals(this.timeoutSeconds(), other.timeoutSeconds()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.outputS3Region(), other.outputS3Region()) && Objects.equals(this.outputS3BucketName(), other.outputS3BucketName()) && Objects.equals(this.outputS3KeyPrefix(), other.outputS3KeyPrefix()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.notificationConfig(), other.notificationConfig()) && Objects.equals(this.cloudWatchOutputConfig(), other.cloudWatchOutputConfig());
    }

    public String toString() {
        return ToString.builder((String)"SendCommandRequest").add("InstanceIds", this.instanceIds()).add("Targets", this.targets()).add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("DocumentHash", (Object)this.documentHash()).add("DocumentHashType", (Object)this.documentHashTypeAsString()).add("TimeoutSeconds", (Object)this.timeoutSeconds()).add("Comment", (Object)this.comment()).add("Parameters", this.parameters()).add("OutputS3Region", (Object)this.outputS3Region()).add("OutputS3BucketName", (Object)this.outputS3BucketName()).add("OutputS3KeyPrefix", (Object)this.outputS3KeyPrefix()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("NotificationConfig", (Object)this.notificationConfig()).add("CloudWatchOutputConfig", (Object)this.cloudWatchOutputConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "DocumentHash": {
                return Optional.ofNullable(clazz.cast(this.documentHash()));
            }
            case "DocumentHashType": {
                return Optional.ofNullable(clazz.cast(this.documentHashTypeAsString()));
            }
            case "TimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutSeconds()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "OutputS3Region": {
                return Optional.ofNullable(clazz.cast(this.outputS3Region()));
            }
            case "OutputS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.outputS3BucketName()));
            }
            case "OutputS3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.outputS3KeyPrefix()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "ServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "NotificationConfig": {
                return Optional.ofNullable(clazz.cast(this.notificationConfig()));
            }
            case "CloudWatchOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchOutputConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendCommandRequest, T> g) {
        return obj -> g.apply((SendCommandRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String documentName;
        private String documentVersion;
        private String documentHash;
        private String documentHashType;
        private Integer timeoutSeconds;
        private String comment;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String outputS3Region;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;
        private String maxConcurrency;
        private String maxErrors;
        private String serviceRoleArn;
        private NotificationConfig notificationConfig;
        private CloudWatchOutputConfig cloudWatchOutputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCommandRequest model) {
            super(model);
            this.instanceIds(model.instanceIds);
            this.targets(model.targets);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.documentHash(model.documentHash);
            this.documentHashType(model.documentHashType);
            this.timeoutSeconds(model.timeoutSeconds);
            this.comment(model.comment);
            this.parameters(model.parameters);
            this.outputS3Region(model.outputS3Region);
            this.outputS3BucketName(model.outputS3BucketName);
            this.outputS3KeyPrefix(model.outputS3KeyPrefix);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.serviceRoleArn(model.serviceRoleArn);
            this.notificationConfig(model.notificationConfig);
            this.cloudWatchOutputConfig(model.cloudWatchOutputConfig);
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getDocumentHash() {
            return this.documentHash;
        }

        @Override
        public final Builder documentHash(String documentHash) {
            this.documentHash = documentHash;
            return this;
        }

        public final void setDocumentHash(String documentHash) {
            this.documentHash = documentHash;
        }

        public final String getDocumentHashType() {
            return this.documentHashType;
        }

        @Override
        public final Builder documentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
            return this;
        }

        @Override
        public final Builder documentHashType(DocumentHashType documentHashType) {
            this.documentHashType(documentHashType.toString());
            return this;
        }

        public final void setDocumentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
        }

        public final Integer getTimeoutSeconds() {
            return this.timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final String getOutputS3Region() {
            return this.outputS3Region;
        }

        @Override
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final NotificationConfig.Builder getNotificationConfig() {
            return this.notificationConfig != null ? this.notificationConfig.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final void setNotificationConfig(NotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        public final CloudWatchOutputConfig.Builder getCloudWatchOutputConfig() {
            return this.cloudWatchOutputConfig != null ? this.cloudWatchOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchOutputConfig(CloudWatchOutputConfig cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig;
            return this;
        }

        public final void setCloudWatchOutputConfig(CloudWatchOutputConfig.BuilderImpl cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig != null ? cloudWatchOutputConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendCommandRequest build() {
            return new SendCommandRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendCommandRequest> {
        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder documentHash(String var1);

        public Builder documentHashType(String var1);

        public Builder documentHashType(DocumentHashType var1);

        public Builder timeoutSeconds(Integer var1);

        public Builder comment(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder outputS3Region(String var1);

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder serviceRoleArn(String var1);

        public Builder notificationConfig(NotificationConfig var1);

        default public Builder notificationConfig(Consumer<NotificationConfig.Builder> notificationConfig) {
            return this.notificationConfig((NotificationConfig)((NotificationConfig.Builder)NotificationConfig.builder().applyMutation(notificationConfig)).build());
        }

        public Builder cloudWatchOutputConfig(CloudWatchOutputConfig var1);

        default public Builder cloudWatchOutputConfig(Consumer<CloudWatchOutputConfig.Builder> cloudWatchOutputConfig) {
            return this.cloudWatchOutputConfig((CloudWatchOutputConfig)((CloudWatchOutputConfig.Builder)CloudWatchOutputConfig.builder().applyMutation(cloudWatchOutputConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

