/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.SeveritySummary;

public class SeveritySummaryUnmarshaller
implements Unmarshaller<SeveritySummary, JsonUnmarshallerContext> {
    private static final SeveritySummaryUnmarshaller INSTANCE = new SeveritySummaryUnmarshaller();

    public SeveritySummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        SeveritySummary.Builder severitySummaryBuilder = SeveritySummary.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("CriticalCount", targetDepth)) {
                    context.nextToken();
                    severitySummaryBuilder.criticalCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("HighCount", targetDepth)) {
                    context.nextToken();
                    severitySummaryBuilder.highCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("MediumCount", targetDepth)) {
                    context.nextToken();
                    severitySummaryBuilder.mediumCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("LowCount", targetDepth)) {
                    context.nextToken();
                    severitySummaryBuilder.lowCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("InformationalCount", targetDepth)) {
                    context.nextToken();
                    severitySummaryBuilder.informationalCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("UnspecifiedCount", targetDepth)) {
                    context.nextToken();
                    severitySummaryBuilder.unspecifiedCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SeveritySummary)severitySummaryBuilder.build();
    }

    public static SeveritySummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

