/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SendAutomationSignalRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTOMATIONEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutomationExecutionId").isBinary(false).build();
    private static final MarshallingInfo<String> SIGNALTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SignalType").isBinary(false).build();
    private static final MarshallingInfo<Map> PAYLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Payload").isBinary(false).build();
    private static final SendAutomationSignalRequestModelMarshaller INSTANCE = new SendAutomationSignalRequestModelMarshaller();

    private SendAutomationSignalRequestModelMarshaller() {
    }

    public static SendAutomationSignalRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SendAutomationSignalRequest sendAutomationSignalRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)sendAutomationSignalRequest), (String)"sendAutomationSignalRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sendAutomationSignalRequest.automationExecutionId(), AUTOMATIONEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)sendAutomationSignalRequest.signalTypeString(), SIGNALTYPE_BINDING);
            protocolMarshaller.marshall(sendAutomationSignalRequest.payload(), PAYLOAD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

